/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.json.GenericJson;
import com.google.api.client.util.Clock;
import com.google.auth.TestUtils;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.BaseSerializationTest;
import com.google.auth.oauth2.GoogleCredentialsTest;
import com.google.auth.oauth2.UserCredentials;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class UserCredentialsTest
extends BaseSerializationTest {
    private static final String CLIENT_SECRET = "jakuaL9YyieakhECKL2SwZcu";
    private static final String CLIENT_ID = "ya29.1.AADtN_UtlxN3PuGAxrN2XQnZTVRvDyVWnYq4I6dws";
    private static final String REFRESH_TOKEN = "1/Tl6awhpFjkMkSJoj1xsli0H2eL5YsMgU_NKPY2TyGWY";
    private static final String ACCESS_TOKEN = "1/MkSJoj1xsli0AccessToken_NKPY2";
    private static final String QUOTA_PROJECT = "sample-quota-project-id";
    private static final Collection<String> SCOPES = Collections.singletonList("dummy.scope");
    private static final URI CALL_URI = URI.create("http://googleapis.com/testapi/v1/foo");

    @Test(expected=IllegalStateException.class)
    public void constructor_accessAndRefreshTokenNull_throws() {
        UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).build();
    }

    @Test
    public void constructor() {
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setQuotaProjectId(QUOTA_PROJECT).build();
        Assert.assertEquals((Object)CLIENT_ID, (Object)credentials.getClientId());
        Assert.assertEquals((Object)CLIENT_SECRET, (Object)credentials.getClientSecret());
        Assert.assertEquals((Object)REFRESH_TOKEN, (Object)credentials.getRefreshToken());
        Assert.assertEquals((Object)QUOTA_PROJECT, (Object)credentials.getQuotaProjectId());
    }

    @Test
    public void createScoped_same() {
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).build();
        Assert.assertSame((Object)userCredentials, (Object)userCredentials.createScoped(SCOPES));
    }

    @Test
    public void createScopedRequired_false() {
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).build();
        Assert.assertFalse((boolean)userCredentials.createScopedRequired());
    }

    @Test
    public void fromJson_hasAccessToken() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN);
        GenericJson json = UserCredentialsTest.writeUserJson(CLIENT_ID, CLIENT_SECRET, REFRESH_TOKEN, null);
        UserCredentials credentials = UserCredentials.fromJson((Map)json, (HttpTransportFactory)transportFactory);
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    @Test
    public void fromJson_hasQuotaProjectId() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN);
        GenericJson json = UserCredentialsTest.writeUserJson(CLIENT_ID, CLIENT_SECRET, REFRESH_TOKEN, QUOTA_PROJECT);
        UserCredentials credentials = UserCredentials.fromJson((Map)json, (HttpTransportFactory)transportFactory);
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        Assert.assertTrue((boolean)metadata.containsKey("x-goog-user-project"));
        Assert.assertEquals(metadata.get("x-goog-user-project"), Collections.singletonList(QUOTA_PROJECT));
    }

    @Test
    public void getRequestMetadata_initialToken_hasAccessToken() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        Map metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    @Test
    public void getRequestMetadata_initialTokenRefreshed_throws() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        try {
            userCredentials.refresh();
            Assert.fail((String)"Should not be able to refresh without refresh token.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void getRequestMetadata_fromRefreshToken_hasAccessToken() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN);
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).build();
        Map metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    @Test
    public void getRequestMetadata_customTokenServer_hasAccessToken() throws IOException {
        URI TOKEN_SERVER = URI.create("https://foo.com/bar");
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN);
        transportFactory.transport.setTokenServerUri(TOKEN_SERVER);
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setHttpTransportFactory((HttpTransportFactory)transportFactory).setTokenServerUri(TOKEN_SERVER).build();
        Map metadata = userCredentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    @Test
    public void equals_true() throws IOException {
        URI tokenServer = URI.create("https://foo.com/bar");
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).setTokenServerUri(tokenServer).setQuotaProjectId(QUOTA_PROJECT).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).setTokenServerUri(tokenServer).setQuotaProjectId(QUOTA_PROJECT).build();
        Assert.assertTrue((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertTrue((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_clientId() throws IOException {
        URI tokenServer1 = URI.create("https://foo1.com/bar");
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        GoogleCredentialsTest.MockHttpTransportFactory httpTransportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId("other client id").setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_clientSecret() throws IOException {
        URI tokenServer1 = URI.create("https://foo1.com/bar");
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        GoogleCredentialsTest.MockHttpTransportFactory httpTransportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret("other client secret").setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_refreshToken() throws IOException {
        URI tokenServer1 = URI.create("https://foo1.com/bar");
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        GoogleCredentialsTest.MockHttpTransportFactory httpTransportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken("otherRefreshToken").setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_accessToken() throws IOException {
        URI tokenServer1 = URI.create("https://foo1.com/bar");
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        AccessToken otherAccessToken = new AccessToken("otherAccessToken", null);
        GoogleCredentialsTest.MockHttpTransportFactory httpTransportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(otherAccessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_transportFactory() throws IOException {
        URI tokenServer1 = URI.create("https://foo1.com/bar");
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        GoogleCredentialsTest.MockHttpTransportFactory httpTransportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        GoogleCredentialsTest.MockTokenServerTransportFactory serverTransportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)serverTransportFactory).setTokenServerUri(tokenServer1).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_tokenServer() throws IOException {
        URI tokenServer1 = URI.create("https://foo1.com/bar");
        URI tokenServer2 = URI.create("https://foo2.com/bar");
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        GoogleCredentialsTest.MockHttpTransportFactory httpTransportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer1).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setTokenServerUri(tokenServer2).build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void equals_false_quotaProjectId() throws IOException {
        String quotaProject1 = "sample-id-1";
        String quotaProject2 = "sample-id-2";
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        GoogleCredentialsTest.MockHttpTransportFactory httpTransportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setQuotaProjectId("sample-id-1").build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)httpTransportFactory).setQuotaProjectId("sample-id-2").build();
        Assert.assertFalse((boolean)credentials.equals((Object)otherCredentials));
        Assert.assertFalse((boolean)otherCredentials.equals((Object)credentials));
    }

    @Test
    public void toString_containsFields() throws IOException {
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        URI tokenServer = URI.create("https://foo.com/bar");
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).setTokenServerUri(tokenServer).setQuotaProjectId(QUOTA_PROJECT).build();
        String expectedToString = String.format("UserCredentials{requestMetadata=%s, temporaryAccess=%s, clientId=%s, refreshToken=%s, tokenServerUri=%s, transportFactoryClassName=%s, quotaProjectId=%s}", ImmutableMap.of((Object)"Authorization", (Object)ImmutableList.of((Object)("Bearer " + accessToken.getTokenValue()))), accessToken.toString(), CLIENT_ID, REFRESH_TOKEN, tokenServer, GoogleCredentialsTest.MockTokenServerTransportFactory.class.getName(), QUOTA_PROJECT);
        Assert.assertEquals((Object)expectedToString, (Object)credentials.toString());
    }

    @Test
    public void hashCode_equals() throws IOException {
        URI tokenServer = URI.create("https://foo.com/bar");
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).setTokenServerUri(tokenServer).setQuotaProjectId(QUOTA_PROJECT).build();
        UserCredentials otherCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).setTokenServerUri(tokenServer).setQuotaProjectId(QUOTA_PROJECT).build();
        Assert.assertEquals((long)credentials.hashCode(), (long)otherCredentials.hashCode());
    }

    @Test
    public void serialize() throws IOException, ClassNotFoundException {
        URI tokenServer = URI.create("https://foo.com/bar");
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        AccessToken accessToken = new AccessToken(ACCESS_TOKEN, null);
        UserCredentials credentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).setAccessToken(accessToken).setHttpTransportFactory((HttpTransportFactory)transportFactory).setTokenServerUri(tokenServer).build();
        UserCredentials deserializedCredentials = this.serializeAndDeserialize(credentials);
        Assert.assertEquals((Object)credentials, (Object)deserializedCredentials);
        Assert.assertEquals((long)credentials.hashCode(), (long)deserializedCredentials.hashCode());
        Assert.assertEquals((Object)credentials.toString(), (Object)deserializedCredentials.toString());
        Assert.assertSame((Object)deserializedCredentials.clock, (Object)Clock.SYSTEM);
    }

    @Test
    public void fromStream_nullTransport_throws() throws IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream("foo".getBytes());
        try {
            UserCredentials.fromStream((InputStream)stream, null);
            Assert.fail((String)"Should throw if HttpTransportFactory is null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void fromStream_nullStream_throws() throws IOException {
        GoogleCredentialsTest.MockHttpTransportFactory transportFactory = new GoogleCredentialsTest.MockHttpTransportFactory();
        try {
            UserCredentials.fromStream(null, (HttpTransportFactory)transportFactory);
            Assert.fail((String)"Should throw if InputStream is null");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void fromStream_user_providesToken() throws IOException {
        GoogleCredentialsTest.MockTokenServerTransportFactory transportFactory = new GoogleCredentialsTest.MockTokenServerTransportFactory();
        transportFactory.transport.addClient(CLIENT_ID, CLIENT_SECRET);
        transportFactory.transport.addRefreshToken(REFRESH_TOKEN, ACCESS_TOKEN);
        InputStream userStream = UserCredentialsTest.writeUserStream(CLIENT_ID, CLIENT_SECRET, REFRESH_TOKEN, QUOTA_PROJECT);
        UserCredentials credentials = UserCredentials.fromStream((InputStream)userStream, (HttpTransportFactory)transportFactory);
        Assert.assertNotNull((Object)credentials);
        Map metadata = credentials.getRequestMetadata(CALL_URI);
        TestUtils.assertContainsBearerToken(metadata, ACCESS_TOKEN);
    }

    @Test
    public void fromStream_userNoClientId_throws() throws IOException {
        InputStream userStream = UserCredentialsTest.writeUserStream(null, CLIENT_SECRET, REFRESH_TOKEN, QUOTA_PROJECT);
        UserCredentialsTest.testFromStreamException(userStream, "client_id");
    }

    @Test
    public void fromStream_userNoClientSecret_throws() throws IOException {
        InputStream userStream = UserCredentialsTest.writeUserStream(CLIENT_ID, null, REFRESH_TOKEN, QUOTA_PROJECT);
        UserCredentialsTest.testFromStreamException(userStream, "client_secret");
    }

    @Test
    public void fromStream_userNoRefreshToken_throws() throws IOException {
        InputStream userStream = UserCredentialsTest.writeUserStream(CLIENT_ID, CLIENT_SECRET, null, QUOTA_PROJECT);
        UserCredentialsTest.testFromStreamException(userStream, "refresh_token");
    }

    @Test
    public void saveUserCredentials_saved_throws() throws IOException {
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).build();
        File file = File.createTempFile("GOOGLE_APPLICATION_CREDENTIALS", null, null);
        file.deleteOnExit();
        String filePath = file.getAbsolutePath();
        userCredentials.save(filePath);
    }

    @Test
    public void saveAndRestoreUserCredential_saveAndRestored_throws() throws IOException {
        UserCredentials userCredentials = UserCredentials.newBuilder().setClientId(CLIENT_ID).setClientSecret(CLIENT_SECRET).setRefreshToken(REFRESH_TOKEN).build();
        File file = File.createTempFile("GOOGLE_APPLICATION_CREDENTIALS", null, null);
        file.deleteOnExit();
        String filePath = file.getAbsolutePath();
        userCredentials.save(filePath);
        FileInputStream inputStream = new FileInputStream(new File(filePath));
        UserCredentials restoredCredentials = UserCredentials.fromStream((InputStream)inputStream);
        Assert.assertEquals((Object)userCredentials.getClientId(), (Object)restoredCredentials.getClientId());
        Assert.assertEquals((Object)userCredentials.getClientSecret(), (Object)restoredCredentials.getClientSecret());
        Assert.assertEquals((Object)userCredentials.getRefreshToken(), (Object)restoredCredentials.getRefreshToken());
    }

    static GenericJson writeUserJson(String clientId, String clientSecret, String refreshToken, String quotaProjectId) {
        GenericJson json = new GenericJson();
        if (clientId != null) {
            json.put("client_id", (Object)clientId);
        }
        if (clientSecret != null) {
            json.put("client_secret", (Object)clientSecret);
        }
        if (refreshToken != null) {
            json.put("refresh_token", (Object)refreshToken);
        }
        if (quotaProjectId != null) {
            json.put("quota_project_id", (Object)quotaProjectId);
        }
        json.put("type", (Object)"authorized_user");
        return json;
    }

    static InputStream writeUserStream(String clientId, String clientSecret, String refreshToken, String quotaProjectId) throws IOException {
        GenericJson json = UserCredentialsTest.writeUserJson(clientId, clientSecret, refreshToken, quotaProjectId);
        return TestUtils.jsonToInputStream(json);
    }

    private static void testFromStreamException(InputStream stream, String expectedMessageContent) {
        try {
            UserCredentials.fromStream((InputStream)stream);
            Assert.fail((String)String.format("Should throw exception with message containing '%s'", expectedMessageContent));
        }
        catch (IOException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains(expectedMessageContent));
        }
    }
}

