/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import java.util.Date;

public class AccessToken {
    private final String tokenValue;
    private final Long expirationTimeMillis;

    public AccessToken(String tokenValue, Date expirationTime) {
        this.tokenValue = tokenValue;
        this.expirationTimeMillis = expirationTime == null ? null : Long.valueOf(expirationTime.getTime());
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public Date getExpirationTime() {
        if (this.expirationTimeMillis == null) {
            return null;
        }
        return new Date(this.expirationTimeMillis);
    }

    Long getExpirationTimeMillis() {
        return this.expirationTimeMillis;
    }
}

