/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.junit.Assert;

public class TestUtils {
    private static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();

    public static void assertContainsBearerToken(Map<String, List<String>> metadata, String token) {
        Assert.assertNotNull(metadata);
        Assert.assertNotNull((Object)token);
        Assert.assertTrue((String)"Bearer token not found", (boolean)TestUtils.hasBearerToken(metadata, token));
    }

    public static void assertNotContainsBearerToken(Map<String, List<String>> metadata, String token) {
        Assert.assertNotNull(metadata);
        Assert.assertNotNull((Object)token);
        Assert.assertFalse((String)"Bearer token found", (boolean)TestUtils.hasBearerToken(metadata, token));
    }

    private static boolean hasBearerToken(Map<String, List<String>> metadata, String token) {
        String expectedValue = "Bearer " + token;
        List<String> authorizations = metadata.get("Authorization");
        Assert.assertNotNull((String)"Authorization headers not found", authorizations);
        return authorizations.contains(expectedValue);
    }

    public static InputStream jsonToInputStream(GenericJson json) throws IOException {
        json.setFactory(JSON_FACTORY);
        String text = json.toPrettyString();
        return new ByteArrayInputStream(text.getBytes("UTF-8"));
    }

    public static InputStream stringToInputStream(String text) {
        try {
            return new ByteArrayInputStream(text.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected encoding exception", e);
        }
    }

    public static Map<String, String> parseQuery(String query) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        Iterable entries = Splitter.on((char)'&').split((CharSequence)query);
        for (String entry : entries) {
            ArrayList sides = Lists.newArrayList((Iterable)Splitter.on((char)'=').split((CharSequence)entry));
            if (sides.size() != 2) {
                throw new IOException("Invalid Query String");
            }
            String key = URLDecoder.decode((String)sides.get(0), "UTF-8");
            String value = URLDecoder.decode((String)sides.get(1), "UTF-8");
            map.put(key, value);
        }
        return map;
    }

    public static String errorJson(String message) throws IOException {
        GenericJson errorResponse = new GenericJson();
        errorResponse.setFactory(JSON_FACTORY);
        GenericJson errorObject = new GenericJson();
        errorObject.put("message", (Object)message);
        errorResponse.put("error", (Object)errorObject);
        return errorResponse.toPrettyString();
    }

    public static HttpResponseException buildHttpResponseException(String error, @Nullable String errorDescription, @Nullable String errorUri) throws IOException {
        GenericJson json = new GenericJson();
        json.setFactory((JsonFactory)GsonFactory.getDefaultInstance());
        json.set("error", (Object)error);
        if (errorDescription != null) {
            json.set("error_description", (Object)errorDescription);
        }
        if (errorUri != null) {
            json.set("error_uri", (Object)errorUri);
        }
        return new HttpResponseException.Builder(400, "statusMessage", new HttpHeaders()).setContent(json.toPrettyString()).build();
    }

    public static String getDefaultExpireTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(13, 300);
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(calendar.getTime());
    }

    private TestUtils() {
    }
}

