/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.auth.TestUtils;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.junit.Assert;

public class MockExternalAccountCredentialsTransport
extends MockHttpTransport {
    private static final String EXPECTED_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:token-exchange";
    private static final String CLOUD_PLATFORM_SCOPE = "https://www.googleapis.com/auth/cloud-platform";
    private static final String ISSUED_TOKEN_TYPE = "urn:ietf:params:oauth:token-type:access_token";
    private static final String AWS_CREDENTIALS_URL = "https://169.254.169.254";
    private static final String AWS_REGION_URL = "https://169.254.169.254/region";
    private static final String AWS_IMDSV2_SESSION_TOKEN_URL = "https://169.254.169.254/imdsv2";
    private static final String METADATA_SERVER_URL = "https://www.metadata.google.com";
    private static final String STS_URL = "https://sts.googleapis.com/v1/token";
    private static final String SUBJECT_TOKEN = "subjectToken";
    private static final String TOKEN_TYPE = "Bearer";
    private static final String ACCESS_TOKEN = "accessToken";
    private static final String AWS_IMDSV2_SESSION_TOKEN = "sessiontoken";
    private static final String SERVICE_ACCOUNT_ACCESS_TOKEN = "serviceAccountAccessToken";
    private static final String AWS_REGION = "us-east-1b";
    private static final Long EXPIRES_IN = 3600L;
    private static final JsonFactory JSON_FACTORY = new GsonFactory();
    static final String SERVICE_ACCOUNT_IMPERSONATION_URL = "https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/testn@test.iam.gserviceaccount.com:generateAccessToken";
    static final String IAM_ENDPOINT = "https://iamcredentials.googleapis.com";
    private Queue<Boolean> responseSequence = new ArrayDeque<Boolean>();
    private Queue<IOException> responseErrorSequence = new ArrayDeque<IOException>();
    private Queue<String> refreshTokenSequence = new ArrayDeque<String>();
    private Queue<List<String>> scopeSequence = new ArrayDeque<List<String>>();
    private List<MockLowLevelHttpRequest> requests = new ArrayList<MockLowLevelHttpRequest>();
    private String expireTime;
    private String metadataServerContentType;
    private String stsContent;

    public void addResponseErrorSequence(IOException ... errors) {
        Collections.addAll(this.responseErrorSequence, errors);
    }

    public void addResponseSequence(Boolean ... responses) {
        Collections.addAll(this.responseSequence, responses);
    }

    public void addRefreshTokenSequence(String ... refreshTokens) {
        Collections.addAll(this.refreshTokenSequence, refreshTokens);
    }

    public void addScopeSequence(List<String> ... scopes) {
        Collections.addAll(this.scopeSequence, scopes);
    }

    public LowLevelHttpRequest buildRequest(String method, final String url) {
        MockLowLevelHttpRequest request = new MockLowLevelHttpRequest(url){

            public LowLevelHttpResponse execute() throws IOException {
                boolean successfulResponse;
                boolean bl = successfulResponse = !MockExternalAccountCredentialsTransport.this.responseSequence.isEmpty() && (Boolean)MockExternalAccountCredentialsTransport.this.responseSequence.poll() != false;
                if (!MockExternalAccountCredentialsTransport.this.responseErrorSequence.isEmpty() && !successfulResponse) {
                    throw (IOException)MockExternalAccountCredentialsTransport.this.responseErrorSequence.poll();
                }
                if (MockExternalAccountCredentialsTransport.AWS_IMDSV2_SESSION_TOKEN_URL.equals(url)) {
                    return new MockLowLevelHttpResponse().setContentType("text/html").setContent(MockExternalAccountCredentialsTransport.AWS_IMDSV2_SESSION_TOKEN);
                }
                if (MockExternalAccountCredentialsTransport.AWS_REGION_URL.equals(url)) {
                    return new MockLowLevelHttpResponse().setContentType("text/html").setContent(MockExternalAccountCredentialsTransport.AWS_REGION);
                }
                if (MockExternalAccountCredentialsTransport.AWS_CREDENTIALS_URL.equals(url)) {
                    return new MockLowLevelHttpResponse().setContentType("text/html").setContent("roleName");
                }
                if ("https://169.254.169.254/roleName".equals(url)) {
                    GenericJson response = new GenericJson();
                    response.setFactory(JSON_FACTORY);
                    response.put("AccessKeyId", (Object)"accessKeyId");
                    response.put("SecretAccessKey", (Object)"secretAccessKey");
                    response.put("Token", (Object)"token");
                    return new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(response.toString());
                }
                if (MockExternalAccountCredentialsTransport.METADATA_SERVER_URL.equals(url)) {
                    String metadataRequestHeader = this.getFirstHeaderValue("Metadata-Flavor");
                    if (!"Google".equals(metadataRequestHeader)) {
                        throw new IOException("Metadata request header not found.");
                    }
                    if (MockExternalAccountCredentialsTransport.this.metadataServerContentType != null && MockExternalAccountCredentialsTransport.this.metadataServerContentType.equals("json")) {
                        GenericJson response = new GenericJson();
                        response.setFactory(JSON_FACTORY);
                        response.put(MockExternalAccountCredentialsTransport.SUBJECT_TOKEN, (Object)MockExternalAccountCredentialsTransport.SUBJECT_TOKEN);
                        return new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(response.toString());
                    }
                    return new MockLowLevelHttpResponse().setContentType("text/html").setContent(MockExternalAccountCredentialsTransport.SUBJECT_TOKEN);
                }
                if (MockExternalAccountCredentialsTransport.STS_URL.equals(url)) {
                    Map<String, String> query = TestUtils.parseQuery(this.getContentAsString());
                    MockExternalAccountCredentialsTransport.this.stsContent = this.getContentAsString();
                    Assert.assertEquals((Object)MockExternalAccountCredentialsTransport.EXPECTED_GRANT_TYPE, (Object)query.get("grant_type"));
                    Assert.assertNotNull((Object)query.get("subject_token_type"));
                    Assert.assertNotNull((Object)query.get("subject_token"));
                    GenericJson response = new GenericJson();
                    response.setFactory(JSON_FACTORY);
                    response.put("token_type", (Object)MockExternalAccountCredentialsTransport.TOKEN_TYPE);
                    response.put("expires_in", (Object)EXPIRES_IN);
                    response.put("access_token", (Object)MockExternalAccountCredentialsTransport.ACCESS_TOKEN);
                    response.put("issued_token_type", (Object)MockExternalAccountCredentialsTransport.ISSUED_TOKEN_TYPE);
                    if (!MockExternalAccountCredentialsTransport.this.refreshTokenSequence.isEmpty()) {
                        response.put("refresh_token", MockExternalAccountCredentialsTransport.this.refreshTokenSequence.poll());
                    }
                    if (!MockExternalAccountCredentialsTransport.this.scopeSequence.isEmpty()) {
                        response.put("scope", (Object)Joiner.on((char)' ').join((Iterable)MockExternalAccountCredentialsTransport.this.scopeSequence.poll()));
                    }
                    return new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(response.toPrettyString());
                }
                if (url.contains(MockExternalAccountCredentialsTransport.IAM_ENDPOINT)) {
                    GenericJson query = (GenericJson)OAuth2Utils.JSON_FACTORY.createJsonParser(this.getContentAsString()).parseAndClose(GenericJson.class);
                    Assert.assertEquals((Object)MockExternalAccountCredentialsTransport.CLOUD_PLATFORM_SCOPE, ((ArrayList)query.get((Object)"scope")).get(0));
                    Assert.assertEquals((long)1L, (long)((List)this.getHeaders().get("authorization")).size());
                    Assert.assertTrue((boolean)this.getHeaders().containsKey("authorization"));
                    Assert.assertNotNull(((List)this.getHeaders().get("authorization")).get(0));
                    GenericJson response = new GenericJson();
                    response.setFactory(JSON_FACTORY);
                    response.put(MockExternalAccountCredentialsTransport.ACCESS_TOKEN, (Object)MockExternalAccountCredentialsTransport.SERVICE_ACCOUNT_ACCESS_TOKEN);
                    response.put("expireTime", (Object)MockExternalAccountCredentialsTransport.this.expireTime);
                    return new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(response.toPrettyString());
                }
                return null;
            }
        };
        this.requests.add(request);
        return request;
    }

    public String getStsContent() {
        return this.stsContent;
    }

    public MockLowLevelHttpRequest getLastRequest() {
        if (this.requests.isEmpty()) {
            return null;
        }
        return this.requests.get(this.requests.size() - 1);
    }

    public List<MockLowLevelHttpRequest> getRequests() {
        return Collections.unmodifiableList(this.requests);
    }

    public String getTokenType() {
        return TOKEN_TYPE;
    }

    public String getAccessToken() {
        return ACCESS_TOKEN;
    }

    public String getServiceAccountAccessToken() {
        return SERVICE_ACCOUNT_ACCESS_TOKEN;
    }

    public String getIssuedTokenType() {
        return ISSUED_TOKEN_TYPE;
    }

    public Long getExpiresIn() {
        return EXPIRES_IN;
    }

    public String getSubjectToken() {
        return SUBJECT_TOKEN;
    }

    public String getMetadataUrl() {
        return METADATA_SERVER_URL;
    }

    public String getAwsCredentialsUrl() {
        return AWS_CREDENTIALS_URL;
    }

    public String getAwsRegionUrl() {
        return AWS_REGION_URL;
    }

    public String getAwsImdsv2SessionTokenUrl() {
        return AWS_IMDSV2_SESSION_TOKEN_URL;
    }

    public String getAwsRegion() {
        return AWS_REGION;
    }

    public String getStsUrl() {
        return STS_URL;
    }

    public String getServiceAccountImpersonationUrl() {
        return SERVICE_ACCOUNT_IMPERSONATION_URL;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    public void setMetadataServerContentType(String contentType) {
        this.metadataServerContentType = contentType;
    }
}

