/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.json.GenericJson;
import com.google.api.client.testing.http.MockHttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.auth.TestUtils;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.common.io.BaseEncoding;
import java.io.IOException;

public class MockIAMCredentialsServiceTransport
extends MockHttpTransport {
    private static final String DEFAULT_IAM_ACCESS_TOKEN_ENDPOINT = "https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:generateAccessToken";
    private static final String IAM_ID_TOKEN_ENDPOINT = "https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:generateIdToken";
    private static final String IAM_SIGN_ENDPOINT = "https://iamcredentials.googleapis.com/v1/projects/-/serviceAccounts/%s:signBlob";
    private Integer tokenResponseErrorCode;
    private String tokenResponseErrorContent;
    private String targetPrincipal;
    private byte[] signedBlob;
    private int responseCode = 200;
    private String errorMessage;
    private String iamAccessTokenEndpoint;
    private String accessToken;
    private String expireTime;
    private String idToken;
    private MockLowLevelHttpRequest request;

    public void setTokenResponseErrorCode(Integer tokenResponseErrorCode) {
        this.tokenResponseErrorCode = tokenResponseErrorCode;
    }

    public void setTokenResponseErrorContent(String tokenResponseErrorContent) {
        this.tokenResponseErrorContent = tokenResponseErrorContent;
    }

    public void setTargetPrincipal(String targetPrincipal) {
        this.targetPrincipal = targetPrincipal;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setExpireTime(String expireTime) {
        this.expireTime = expireTime;
    }

    public void setSignedBlob(byte[] signedBlob) {
        this.signedBlob = signedBlob;
    }

    public void setErrorResponseCodeAndMessage(int responseCode, String errorMessage) {
        this.responseCode = responseCode;
        this.errorMessage = errorMessage;
    }

    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public void setAccessTokenEndpoint(String accessTokenEndpoint) {
        this.iamAccessTokenEndpoint = accessTokenEndpoint;
    }

    public MockLowLevelHttpRequest getRequest() {
        return this.request;
    }

    public LowLevelHttpRequest buildRequest(String method, String url) throws IOException {
        String iamAccesssTokenformattedUrl = this.iamAccessTokenEndpoint != null ? this.iamAccessTokenEndpoint : String.format(DEFAULT_IAM_ACCESS_TOKEN_ENDPOINT, this.targetPrincipal);
        String iamSignBlobformattedUrl = String.format(IAM_SIGN_ENDPOINT, this.targetPrincipal);
        String iamIdTokenformattedUrl = String.format(IAM_ID_TOKEN_ENDPOINT, this.targetPrincipal);
        if (url.equals(iamAccesssTokenformattedUrl)) {
            this.request = new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    if (MockIAMCredentialsServiceTransport.this.tokenResponseErrorCode != null) {
                        return new MockLowLevelHttpResponse().setStatusCode(MockIAMCredentialsServiceTransport.this.tokenResponseErrorCode.intValue()).setContentType("application/json; charset=UTF-8").setContent(MockIAMCredentialsServiceTransport.this.tokenResponseErrorContent);
                    }
                    GenericJson refreshContents = new GenericJson();
                    refreshContents.setFactory(OAuth2Utils.JSON_FACTORY);
                    refreshContents.put("accessToken", (Object)MockIAMCredentialsServiceTransport.this.accessToken);
                    refreshContents.put("expireTime", (Object)MockIAMCredentialsServiceTransport.this.expireTime);
                    String refreshText = refreshContents.toPrettyString();
                    return new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(refreshText);
                }
            };
        } else if (url.equals(iamSignBlobformattedUrl) && this.responseCode != 200) {
            this.request = new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    if (MockIAMCredentialsServiceTransport.this.tokenResponseErrorCode != null) {
                        return new MockLowLevelHttpResponse().setStatusCode(MockIAMCredentialsServiceTransport.this.tokenResponseErrorCode.intValue()).setContentType("application/json; charset=UTF-8").setContent(MockIAMCredentialsServiceTransport.this.tokenResponseErrorContent);
                    }
                    BaseEncoding base64 = BaseEncoding.base64();
                    GenericJson refreshContents = new GenericJson();
                    refreshContents.setFactory(OAuth2Utils.JSON_FACTORY);
                    refreshContents.put("signedBlob", (Object)base64.encode(MockIAMCredentialsServiceTransport.this.signedBlob));
                    return new MockLowLevelHttpResponse().setStatusCode(MockIAMCredentialsServiceTransport.this.responseCode).setContent(TestUtils.errorJson(MockIAMCredentialsServiceTransport.this.errorMessage));
                }
            };
        } else if (url.equals(iamSignBlobformattedUrl)) {
            this.request = new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    if (MockIAMCredentialsServiceTransport.this.tokenResponseErrorCode != null) {
                        return new MockLowLevelHttpResponse().setStatusCode(MockIAMCredentialsServiceTransport.this.tokenResponseErrorCode.intValue()).setContentType("application/json; charset=UTF-8").setContent(MockIAMCredentialsServiceTransport.this.tokenResponseErrorContent);
                    }
                    BaseEncoding base64 = BaseEncoding.base64();
                    GenericJson refreshContents = new GenericJson();
                    refreshContents.setFactory(OAuth2Utils.JSON_FACTORY);
                    refreshContents.put("signedBlob", (Object)base64.encode(MockIAMCredentialsServiceTransport.this.signedBlob));
                    String refreshText = refreshContents.toPrettyString();
                    return new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(refreshText);
                }
            };
        } else if (url.equals(iamIdTokenformattedUrl)) {
            this.request = new MockLowLevelHttpRequest(url){

                public LowLevelHttpResponse execute() throws IOException {
                    if (MockIAMCredentialsServiceTransport.this.responseCode != 200) {
                        return new MockLowLevelHttpResponse().setStatusCode(MockIAMCredentialsServiceTransport.this.responseCode).setContentType("application/json; charset=UTF-8").setContent(MockIAMCredentialsServiceTransport.this.errorMessage);
                    }
                    GenericJson refreshContents = new GenericJson();
                    refreshContents.setFactory(OAuth2Utils.JSON_FACTORY);
                    refreshContents.put("token", (Object)MockIAMCredentialsServiceTransport.this.idToken);
                    String tokenContent = refreshContents.toPrettyString();
                    return new MockLowLevelHttpResponse().setContentType("application/json; charset=UTF-8").setContent(tokenContent);
                }
            };
        } else {
            return super.buildRequest(method, url);
        }
        return this.request;
    }
}

