/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.RequestMetadataCallback;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public final class MockRequestMetadataCallback
implements RequestMetadataCallback {
    volatile Map<String, List<String>> metadata;
    volatile Throwable exception;
    CountDownLatch latch = new CountDownLatch(1);

    public void onSuccess(Map<String, List<String>> metadata) {
        this.checkNotSet();
        this.metadata = metadata;
        this.latch.countDown();
    }

    public void onFailure(Throwable exception) {
        this.checkNotSet();
        this.exception = exception;
        this.latch.countDown();
    }

    public void reset() {
        this.metadata = null;
        this.exception = null;
        this.latch = new CountDownLatch(1);
    }

    public Map<String, List<String>> awaitResult() throws Throwable {
        this.latch.await();
        if (this.exception != null) {
            throw this.exception;
        }
        return this.metadata;
    }

    private void checkNotSet() {
        Preconditions.checkState((this.metadata == null ? 1 : 0) != 0);
        Preconditions.checkState((this.exception == null ? 1 : 0) != 0);
    }
}

