/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.HttpTransport;
import com.google.api.client.testing.http.MockLowLevelHttpRequest;
import com.google.api.client.testing.http.MockLowLevelHttpResponse;
import com.google.auth.oauth2.MockTokenServerTransport;
import java.io.IOException;

public class MockTokenCheckingTransport
extends HttpTransport {
    public static final String SUCCESS_CONTENT = "{\"key\":\"value\"}";
    private MockTokenServerTransport tokenServer;
    private String refreshToken;

    public MockTokenCheckingTransport(MockTokenServerTransport tokenServer, String refreshToken) {
        this.tokenServer = tokenServer;
        this.refreshToken = refreshToken;
    }

    public MockLowLevelHttpRequest buildRequest(String method, String url) throws IOException {
        return new MockLowLevelHttpRequest(){

            public MockLowLevelHttpResponse execute() throws IOException {
                String credentialValue = this.getFirstHeaderValue("Authorization");
                String correctAccessToken = MockTokenCheckingTransport.this.tokenServer.getAccessToken(MockTokenCheckingTransport.this.refreshToken);
                if (credentialValue == null) {
                    return MockTokenCheckingTransport.this.makeErrorResponse();
                }
                if (!credentialValue.startsWith("Bearer ")) {
                    return MockTokenCheckingTransport.this.makeErrorResponse();
                }
                String actualAccessToken = credentialValue.substring("Bearer ".length());
                if (!correctAccessToken.equals(actualAccessToken)) {
                    return MockTokenCheckingTransport.this.makeErrorResponse();
                }
                return MockTokenCheckingTransport.this.makeSuccessResponse();
            }
        };
    }

    private MockLowLevelHttpResponse makeErrorResponse() {
        MockLowLevelHttpResponse errorResponse = new MockLowLevelHttpResponse();
        errorResponse.addHeader("custom_header", "value");
        errorResponse.setStatusCode(401);
        errorResponse.setContentType("application/json; charset=UTF-8");
        errorResponse.setContent("{\"error\":\"invalid credentials\"}");
        return errorResponse;
    }

    private MockLowLevelHttpResponse makeSuccessResponse() {
        MockLowLevelHttpResponse successResponse = new MockLowLevelHttpResponse();
        successResponse.addHeader("custom_header", "value");
        successResponse.setStatusCode(200);
        successResponse.setContentType("application/json; charset=UTF-8");
        successResponse.setContent(SUCCESS_CONTENT);
        return successResponse;
    }
}

