/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Joiner;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.SecurityUtils;
import com.google.auth.RequestMetadataCallback;
import com.google.auth.ServiceAccountSigner;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleAuthException;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.IdToken;
import com.google.auth.oauth2.IdTokenProvider;
import com.google.auth.oauth2.JwtClaims;
import com.google.auth.oauth2.JwtCredentials;
import com.google.auth.oauth2.JwtProvider;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.QuotaProjectIdProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class ServiceAccountCredentials
extends GoogleCredentials
implements ServiceAccountSigner,
IdTokenProvider,
JwtProvider,
QuotaProjectIdProvider {
    private static final long serialVersionUID = 7807543542681217978L;
    private static final String GRANT_TYPE = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    private static final String PARSE_ERROR_PREFIX = "Error parsing token refresh response. ";
    private static final int TWELVE_HOURS_IN_SECONDS = 43200;
    private static final int DEFAULT_LIFETIME_IN_SECONDS = 3600;
    private static final int DEFAULT_NUMBER_OF_RETRIES = 3;
    private static final int INITIAL_RETRY_INTERVAL_MILLIS = 1000;
    private static final double RETRY_RANDOMIZATION_FACTOR = 0.1;
    private static final double RETRY_MULTIPLIER = 2.0;
    private final String clientId;
    private final String clientEmail;
    private final PrivateKey privateKey;
    private final String privateKeyId;
    private final String serviceAccountUser;
    private final String projectId;
    private final String transportFactoryClassName;
    private final URI tokenServerUri;
    private final Collection<String> scopes;
    private final Collection<String> defaultScopes;
    private final String quotaProjectId;
    private final int lifetime;
    private final boolean useJwtAccessWithScope;
    private final boolean defaultRetriesEnabled;
    private transient HttpTransportFactory transportFactory;
    private transient JwtCredentials selfSignedJwtCredentialsWithScope = null;

    ServiceAccountCredentials(Builder builder) {
        this.clientId = builder.clientId;
        this.clientEmail = (String)Preconditions.checkNotNull((Object)builder.clientEmail);
        this.privateKey = (PrivateKey)Preconditions.checkNotNull((Object)builder.privateKey);
        this.privateKeyId = builder.privateKeyId;
        this.scopes = builder.scopes == null ? ImmutableSet.of() : ImmutableSet.copyOf((Collection)builder.scopes);
        this.defaultScopes = builder.defaultScopes == null ? ImmutableSet.of() : ImmutableSet.copyOf((Collection)builder.defaultScopes);
        this.transportFactory = (HttpTransportFactory)MoreObjects.firstNonNull((Object)builder.transportFactory, (Object)ServiceAccountCredentials.getFromServiceLoader(HttpTransportFactory.class, OAuth2Utils.HTTP_TRANSPORT_FACTORY));
        this.transportFactoryClassName = this.transportFactory.getClass().getName();
        this.tokenServerUri = builder.tokenServerUri == null ? OAuth2Utils.TOKEN_SERVER_URI : builder.tokenServerUri;
        this.serviceAccountUser = builder.serviceAccountUser;
        this.projectId = builder.projectId;
        this.quotaProjectId = builder.quotaProjectId;
        if (builder.lifetime > 43200) {
            throw new IllegalStateException("lifetime must be less than or equal to 43200");
        }
        this.lifetime = builder.lifetime;
        this.useJwtAccessWithScope = builder.useJwtAccessWithScope;
        this.defaultRetriesEnabled = builder.defaultRetriesEnabled;
    }

    static ServiceAccountCredentials fromJson(Map<String, Object> json, HttpTransportFactory transportFactory) throws IOException {
        String clientId = (String)json.get("client_id");
        String clientEmail = (String)json.get("client_email");
        String privateKeyPkcs8 = (String)json.get("private_key");
        String privateKeyId = (String)json.get("private_key_id");
        String projectId = (String)json.get("project_id");
        String tokenServerUriStringFromCreds = (String)json.get("token_uri");
        String quotaProjectId = (String)json.get("quota_project_id");
        URI tokenServerUriFromCreds = null;
        try {
            if (tokenServerUriStringFromCreds != null) {
                tokenServerUriFromCreds = new URI(tokenServerUriStringFromCreds);
            }
        }
        catch (URISyntaxException e) {
            throw new IOException("Token server URI specified in 'token_uri' could not be parsed.");
        }
        if (clientId == null || clientEmail == null || privateKeyPkcs8 == null || privateKeyId == null) {
            throw new IOException("Error reading service account credential from JSON, expecting  'client_id', 'client_email', 'private_key' and 'private_key_id'.");
        }
        Builder builder = ServiceAccountCredentials.newBuilder().setClientId(clientId).setClientEmail(clientEmail).setPrivateKeyId(privateKeyId).setHttpTransportFactory(transportFactory).setTokenServerUri(tokenServerUriFromCreds).setProjectId(projectId).setQuotaProjectId(quotaProjectId);
        return ServiceAccountCredentials.fromPkcs8(privateKeyPkcs8, builder);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes) throws IOException {
        Builder builder = ServiceAccountCredentials.newBuilder().setClientId(clientId).setClientEmail(clientEmail).setPrivateKeyId(privateKeyId).setScopes(scopes);
        return ServiceAccountCredentials.fromPkcs8(privateKeyPkcs8, builder);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes, Collection<String> defaultScopes) throws IOException {
        Builder builder = ServiceAccountCredentials.newBuilder().setClientId(clientId).setClientEmail(clientEmail).setPrivateKeyId(privateKeyId).setScopes(scopes, defaultScopes);
        return ServiceAccountCredentials.fromPkcs8(privateKeyPkcs8, builder);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes, HttpTransportFactory transportFactory, URI tokenServerUri) throws IOException {
        Builder builder = ServiceAccountCredentials.newBuilder().setClientId(clientId).setClientEmail(clientEmail).setPrivateKeyId(privateKeyId).setScopes(scopes).setHttpTransportFactory(transportFactory).setTokenServerUri(tokenServerUri);
        return ServiceAccountCredentials.fromPkcs8(privateKeyPkcs8, builder);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes, Collection<String> defaultScopes, HttpTransportFactory transportFactory, URI tokenServerUri) throws IOException {
        Builder builder = ServiceAccountCredentials.newBuilder().setClientId(clientId).setClientEmail(clientEmail).setPrivateKeyId(privateKeyId).setScopes(scopes, defaultScopes).setHttpTransportFactory(transportFactory).setTokenServerUri(tokenServerUri);
        return ServiceAccountCredentials.fromPkcs8(privateKeyPkcs8, builder);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes, HttpTransportFactory transportFactory, URI tokenServerUri, String serviceAccountUser) throws IOException {
        Builder builder = ServiceAccountCredentials.newBuilder().setClientId(clientId).setClientEmail(clientEmail).setPrivateKeyId(privateKeyId).setScopes(scopes).setHttpTransportFactory(transportFactory).setTokenServerUri(tokenServerUri).setServiceAccountUser(serviceAccountUser);
        return ServiceAccountCredentials.fromPkcs8(privateKeyPkcs8, builder);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes, Collection<String> defaultScopes, HttpTransportFactory transportFactory, URI tokenServerUri, String serviceAccountUser) throws IOException {
        Builder builder = ServiceAccountCredentials.newBuilder().setClientId(clientId).setClientEmail(clientEmail).setPrivateKeyId(privateKeyId).setScopes(scopes, defaultScopes).setHttpTransportFactory(transportFactory).setTokenServerUri(tokenServerUri).setServiceAccountUser(serviceAccountUser);
        return ServiceAccountCredentials.fromPkcs8(privateKeyPkcs8, builder);
    }

    static ServiceAccountCredentials fromPkcs8(String privateKeyPkcs8, Builder builder) throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8(privateKeyPkcs8);
        builder.setPrivateKey(privateKey);
        return new ServiceAccountCredentials(builder);
    }

    static PrivateKey privateKeyFromPkcs8(String privateKeyPkcs8) throws IOException {
        StringReader reader = new StringReader(privateKeyPkcs8);
        PemReader.Section section = PemReader.readFirstSectionAndClose((Reader)reader, (String)"PRIVATE KEY");
        if (section == null) {
            throw new IOException("Invalid PKCS#8 data.");
        }
        byte[] bytes = section.getBase64DecodedBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        try {
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException exception) {
            GeneralSecurityException unexpectedException = exception;
            throw new IOException("Unexpected exception reading PKCS#8 data", unexpectedException);
        }
    }

    public static ServiceAccountCredentials fromStream(InputStream credentialsStream) throws IOException {
        return ServiceAccountCredentials.fromStream(credentialsStream, OAuth2Utils.HTTP_TRANSPORT_FACTORY);
    }

    public static ServiceAccountCredentials fromStream(InputStream credentialsStream, HttpTransportFactory transportFactory) throws IOException {
        Preconditions.checkNotNull((Object)credentialsStream);
        Preconditions.checkNotNull((Object)transportFactory);
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        JsonObjectParser parser = new JsonObjectParser(jsonFactory);
        GenericJson fileContents = (GenericJson)parser.parseAndClose(credentialsStream, StandardCharsets.UTF_8, GenericJson.class);
        String fileType = (String)fileContents.get((Object)"type");
        if (fileType == null) {
            throw new IOException("Error reading credentials from stream, 'type' field not specified.");
        }
        if ("service_account".equals(fileType)) {
            return ServiceAccountCredentials.fromJson((Map<String, Object>)fileContents, transportFactory);
        }
        throw new IOException(String.format("Error reading credentials from stream, 'type' value '%s' not recognized. Expecting '%s'.", fileType, "service_account"));
    }

    @Override
    public boolean createScopedRequired() {
        return this.scopes.isEmpty() && this.defaultScopes.isEmpty();
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        HttpResponse response;
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        long currentTime = this.clock.currentTimeMillis();
        String assertion = this.createAssertion(jsonFactory, currentTime);
        GenericData tokenRequest = new GenericData();
        tokenRequest.set("grant_type", (Object)GRANT_TYPE);
        tokenRequest.set("assertion", (Object)assertion);
        UrlEncodedContent content = new UrlEncodedContent((Object)tokenRequest);
        HttpRequestFactory requestFactory = this.transportFactory.create().createRequestFactory();
        HttpRequest request = requestFactory.buildPostRequest(new GenericUrl(this.tokenServerUri), (HttpContent)content);
        if (this.defaultRetriesEnabled) {
            request.setNumberOfRetries(3);
        } else {
            request.setNumberOfRetries(0);
        }
        request.setParser((ObjectParser)new JsonObjectParser(jsonFactory));
        ExponentialBackOff backoff = new ExponentialBackOff.Builder().setInitialIntervalMillis(1000).setRandomizationFactor(0.1).setMultiplier(2.0).build();
        request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)new HttpBackOffUnsuccessfulResponseHandler((BackOff)backoff).setBackOffRequired(new HttpBackOffUnsuccessfulResponseHandler.BackOffRequired(){

            public boolean isRequired(HttpResponse response) {
                int code = response.getStatusCode();
                return OAuth2Utils.TOKEN_ENDPOINT_RETRYABLE_STATUS_CODES.contains(code);
            }
        }));
        String errorTemplate = "Error getting access token for service account: %s, iss: %s";
        try {
            response = request.execute();
        }
        catch (HttpResponseException re) {
            String message = String.format(errorTemplate, re.getMessage(), this.getIssuer());
            throw GoogleAuthException.createWithTokenEndpointResponseException(re, message);
        }
        catch (IOException e) {
            throw new IOException(String.format(errorTemplate, e.getMessage(), this.getIssuer()), e);
        }
        GenericData responseData = (GenericData)response.parseAs(GenericData.class);
        String accessToken = OAuth2Utils.validateString((Map<String, Object>)responseData, "access_token", PARSE_ERROR_PREFIX);
        int expiresInSeconds = OAuth2Utils.validateInt32((Map<String, Object>)responseData, "expires_in", PARSE_ERROR_PREFIX);
        long expiresAtMilliseconds = this.clock.currentTimeMillis() + (long)expiresInSeconds * 1000L;
        return new AccessToken(accessToken, new Date(expiresAtMilliseconds));
    }

    @Override
    public IdToken idTokenWithAudience(String targetAudience, List<IdTokenProvider.Option> options) throws IOException {
        HttpResponse response;
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        long currentTime = this.clock.currentTimeMillis();
        String assertion = this.createAssertionForIdToken(jsonFactory, currentTime, this.tokenServerUri.toString(), targetAudience);
        GenericData tokenRequest = new GenericData();
        tokenRequest.set("grant_type", (Object)GRANT_TYPE);
        tokenRequest.set("assertion", (Object)assertion);
        UrlEncodedContent content = new UrlEncodedContent((Object)tokenRequest);
        HttpRequestFactory requestFactory = this.transportFactory.create().createRequestFactory();
        HttpRequest request = requestFactory.buildPostRequest(new GenericUrl(this.tokenServerUri), (HttpContent)content);
        request.setParser((ObjectParser)new JsonObjectParser(jsonFactory));
        try {
            response = request.execute();
        }
        catch (IOException e) {
            throw new IOException(String.format("Error getting id token for service account: %s, iss: %s", e.getMessage(), this.getIssuer()), e);
        }
        GenericData responseData = (GenericData)response.parseAs(GenericData.class);
        String rawToken = OAuth2Utils.validateString((Map<String, Object>)responseData, "id_token", PARSE_ERROR_PREFIX);
        return IdToken.create(rawToken);
    }

    @Override
    public ServiceAccountCredentials createWithCustomRetryStrategy(boolean defaultRetriesEnabled) {
        return this.toBuilder().setDefaultRetriesEnabled(defaultRetriesEnabled).build();
    }

    @Override
    public GoogleCredentials createScoped(Collection<String> newScopes) {
        return this.createScoped(newScopes, null);
    }

    @Override
    public GoogleCredentials createScoped(Collection<String> newScopes, Collection<String> newDefaultScopes) {
        return this.toBuilder().setScopes(newScopes, newDefaultScopes).build();
    }

    public ServiceAccountCredentials createWithCustomLifetime(int lifetime) {
        return this.toBuilder().setLifetime(lifetime).build();
    }

    public ServiceAccountCredentials createWithUseJwtAccessWithScope(boolean useJwtAccessWithScope) {
        return this.toBuilder().setUseJwtAccessWithScope(useJwtAccessWithScope).build();
    }

    @Override
    public GoogleCredentials createDelegated(String user) {
        return this.toBuilder().setServiceAccountUser(user).build();
    }

    public final String getClientId() {
        return this.clientId;
    }

    public final String getClientEmail() {
        return this.clientEmail;
    }

    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public final String getPrivateKeyId() {
        return this.privateKeyId;
    }

    public final Collection<String> getScopes() {
        return this.scopes;
    }

    public final Collection<String> getDefaultScopes() {
        return this.defaultScopes;
    }

    public final String getServiceAccountUser() {
        return this.serviceAccountUser;
    }

    public final String getProjectId() {
        return this.projectId;
    }

    public final URI getTokenServerUri() {
        return this.tokenServerUri;
    }

    private String getIssuer() {
        return this.clientEmail;
    }

    @VisibleForTesting
    int getLifetime() {
        return this.lifetime;
    }

    public boolean getUseJwtAccessWithScope() {
        return this.useJwtAccessWithScope;
    }

    @VisibleForTesting
    JwtCredentials getSelfSignedJwtCredentialsWithScope() {
        return this.selfSignedJwtCredentialsWithScope;
    }

    public String getAccount() {
        return this.getClientEmail();
    }

    public byte[] sign(byte[] toSign) {
        try {
            Signature signer = Signature.getInstance("SHA256withRSA");
            signer.initSign(this.getPrivateKey());
            signer.update(toSign);
            return signer.sign();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
            throw new ServiceAccountSigner.SigningException("Failed to sign the provided bytes", (Exception)ex);
        }
    }

    @Override
    public JwtCredentials jwtWithClaims(JwtClaims newClaims) {
        JwtClaims.Builder claimsBuilder = JwtClaims.newBuilder().setIssuer(this.getIssuer()).setSubject(this.clientEmail);
        return JwtCredentials.newBuilder().setPrivateKey(this.privateKey).setPrivateKeyId(this.privateKeyId).setJwtClaims(claimsBuilder.build().merge(newClaims)).setClock(this.clock).build();
    }

    @Override
    protected Map<String, List<String>> getAdditionalHeaders() {
        Map<String, List<String>> headers = super.getAdditionalHeaders();
        if (this.quotaProjectId != null) {
            return ServiceAccountCredentials.addQuotaProjectIdToRequestMetadata(this.quotaProjectId, headers);
        }
        return headers;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clientId, this.clientEmail, this.privateKey, this.privateKeyId, this.transportFactoryClassName, this.tokenServerUri, this.scopes, this.defaultScopes, this.quotaProjectId, this.lifetime, this.useJwtAccessWithScope, this.defaultRetriesEnabled);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.clientId).add("clientEmail", (Object)this.clientEmail).add("privateKeyId", (Object)this.privateKeyId).add("transportFactoryClassName", (Object)this.transportFactoryClassName).add("tokenServerUri", (Object)this.tokenServerUri).add("scopes", this.scopes).add("defaultScopes", this.defaultScopes).add("serviceAccountUser", (Object)this.serviceAccountUser).add("quotaProjectId", (Object)this.quotaProjectId).add("lifetime", this.lifetime).add("useJwtAccessWithScope", this.useJwtAccessWithScope).add("defaultRetriesEnabled", this.defaultRetriesEnabled).toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceAccountCredentials)) {
            return false;
        }
        ServiceAccountCredentials other = (ServiceAccountCredentials)obj;
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.clientEmail, other.clientEmail) && Objects.equals(this.privateKey, other.privateKey) && Objects.equals(this.privateKeyId, other.privateKeyId) && Objects.equals(this.transportFactoryClassName, other.transportFactoryClassName) && Objects.equals(this.tokenServerUri, other.tokenServerUri) && Objects.equals(this.scopes, other.scopes) && Objects.equals(this.defaultScopes, other.defaultScopes) && Objects.equals(this.quotaProjectId, other.quotaProjectId) && Objects.equals(this.lifetime, other.lifetime) && Objects.equals(this.useJwtAccessWithScope, other.useJwtAccessWithScope) && Objects.equals(this.defaultRetriesEnabled, other.defaultRetriesEnabled);
    }

    String createAssertion(JsonFactory jsonFactory, long currentTime) throws IOException {
        String assertion;
        JsonWebSignature.Header header = new JsonWebSignature.Header();
        header.setAlgorithm("RS256");
        header.setType("JWT");
        header.setKeyId(this.privateKeyId);
        JsonWebToken.Payload payload = new JsonWebToken.Payload();
        payload.setIssuer(this.getIssuer());
        payload.setIssuedAtTimeSeconds(Long.valueOf(currentTime / 1000L));
        payload.setExpirationTimeSeconds(Long.valueOf(currentTime / 1000L + (long)this.lifetime));
        payload.setSubject(this.serviceAccountUser);
        if (this.scopes.isEmpty()) {
            payload.put("scope", (Object)Joiner.on((char)' ').join(this.defaultScopes));
        } else {
            payload.put("scope", (Object)Joiner.on((char)' ').join(this.scopes));
        }
        payload.setAudience((Object)OAuth2Utils.TOKEN_SERVER_URI.toString());
        try {
            assertion = JsonWebSignature.signUsingRsaSha256((PrivateKey)this.privateKey, (JsonFactory)jsonFactory, (JsonWebSignature.Header)header, (JsonWebToken.Payload)payload);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error signing service account access token request with private key.", e);
        }
        return assertion;
    }

    @VisibleForTesting
    String createAssertionForIdToken(JsonFactory jsonFactory, long currentTime, String audience, String targetAudience) throws IOException {
        JsonWebSignature.Header header = new JsonWebSignature.Header();
        header.setAlgorithm("RS256");
        header.setType("JWT");
        header.setKeyId(this.privateKeyId);
        JsonWebToken.Payload payload = new JsonWebToken.Payload();
        payload.setIssuer(this.getIssuer());
        payload.setIssuedAtTimeSeconds(Long.valueOf(currentTime / 1000L));
        payload.setExpirationTimeSeconds(Long.valueOf(currentTime / 1000L + (long)this.lifetime));
        payload.setSubject(this.serviceAccountUser);
        if (audience == null) {
            payload.setAudience((Object)OAuth2Utils.TOKEN_SERVER_URI.toString());
        } else {
            payload.setAudience((Object)audience);
        }
        try {
            payload.set("target_audience", (Object)targetAudience);
            String assertion = JsonWebSignature.signUsingRsaSha256((PrivateKey)this.privateKey, (JsonFactory)jsonFactory, (JsonWebSignature.Header)header, (JsonWebToken.Payload)payload);
            return assertion;
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error signing service account access token request with private key.", e);
        }
    }

    @VisibleForTesting
    static URI getUriForSelfSignedJWT(URI uri) {
        if (uri == null || uri.getScheme() == null || uri.getHost() == null) {
            return uri;
        }
        try {
            return new URI(uri.getScheme(), uri.getHost(), "/", null);
        }
        catch (URISyntaxException unused) {
            return uri;
        }
    }

    @VisibleForTesting
    JwtCredentials createSelfSignedJwtCredentials(URI uri) {
        JwtClaims.Builder claimsBuilder = JwtClaims.newBuilder().setIssuer(this.clientEmail).setSubject(this.clientEmail);
        if (uri == null) {
            String scopeClaim = "";
            scopeClaim = !this.scopes.isEmpty() ? Joiner.on((char)' ').join(this.scopes) : Joiner.on((char)' ').join(this.defaultScopes);
            claimsBuilder.setAdditionalClaims(Collections.singletonMap("scope", scopeClaim));
        } else {
            claimsBuilder.setAudience(ServiceAccountCredentials.getUriForSelfSignedJWT(uri).toString());
        }
        return JwtCredentials.newBuilder().setPrivateKey(this.privateKey).setPrivateKeyId(this.privateKeyId).setJwtClaims(claimsBuilder.build()).setClock(this.clock).build();
    }

    @Override
    public void getRequestMetadata(URI uri, Executor executor, RequestMetadataCallback callback) {
        if (this.useJwtAccessWithScope) {
            this.blockingGetToCallback(uri, callback);
        } else {
            super.getRequestMetadata(uri, executor, callback);
        }
    }

    @Override
    public Map<String, List<String>> getRequestMetadata(URI uri) throws IOException {
        JwtCredentials jwtCredentials;
        if (this.createScopedRequired() && uri == null) {
            throw new IOException("Scopes and uri are not configured for service account. Specify the scopes by calling createScoped or passing scopes to constructor or providing uri to getRequestMetadata.");
        }
        if (!this.createScopedRequired() && !this.useJwtAccessWithScope || this.serviceAccountUser != null && this.serviceAccountUser.length() > 0) {
            return super.getRequestMetadata(uri);
        }
        if (!this.createScopedRequired() && this.useJwtAccessWithScope) {
            if (this.selfSignedJwtCredentialsWithScope == null) {
                this.selfSignedJwtCredentialsWithScope = this.createSelfSignedJwtCredentials(null);
            }
            jwtCredentials = this.selfSignedJwtCredentialsWithScope;
        } else {
            jwtCredentials = this.createSelfSignedJwtCredentials(uri);
        }
        Map<String, List<String>> requestMetadata = jwtCredentials.getRequestMetadata(null);
        return ServiceAccountCredentials.addQuotaProjectIdToRequestMetadata(this.quotaProjectId, requestMetadata);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.transportFactory = (HttpTransportFactory)ServiceAccountCredentials.newInstance(this.transportFactoryClassName);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public String getQuotaProjectId() {
        return this.quotaProjectId;
    }

    public static class Builder
    extends GoogleCredentials.Builder {
        private String clientId;
        private String clientEmail;
        private PrivateKey privateKey;
        private String privateKeyId;
        private String serviceAccountUser;
        private String projectId;
        private URI tokenServerUri;
        private Collection<String> scopes;
        private Collection<String> defaultScopes;
        private HttpTransportFactory transportFactory;
        private String quotaProjectId;
        private int lifetime = 3600;
        private boolean useJwtAccessWithScope = false;
        private boolean defaultRetriesEnabled = true;

        protected Builder() {
        }

        protected Builder(ServiceAccountCredentials credentials) {
            this.clientId = credentials.clientId;
            this.clientEmail = credentials.clientEmail;
            this.privateKey = credentials.privateKey;
            this.privateKeyId = credentials.privateKeyId;
            this.scopes = credentials.scopes;
            this.defaultScopes = credentials.defaultScopes;
            this.transportFactory = credentials.transportFactory;
            this.tokenServerUri = credentials.tokenServerUri;
            this.serviceAccountUser = credentials.serviceAccountUser;
            this.projectId = credentials.projectId;
            this.quotaProjectId = credentials.quotaProjectId;
            this.lifetime = credentials.lifetime;
            this.useJwtAccessWithScope = credentials.useJwtAccessWithScope;
            this.defaultRetriesEnabled = credentials.defaultRetriesEnabled;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientEmail(String clientEmail) {
            this.clientEmail = clientEmail;
            return this;
        }

        public Builder setPrivateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder setPrivateKeyId(String privateKeyId) {
            this.privateKeyId = privateKeyId;
            return this;
        }

        public Builder setScopes(Collection<String> scopes) {
            this.scopes = scopes;
            this.defaultScopes = ImmutableSet.of();
            return this;
        }

        public Builder setScopes(Collection<String> scopes, Collection<String> defaultScopes) {
            this.scopes = scopes;
            this.defaultScopes = defaultScopes;
            return this;
        }

        public Builder setServiceAccountUser(String serviceAccountUser) {
            this.serviceAccountUser = serviceAccountUser;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setTokenServerUri(URI tokenServerUri) {
            this.tokenServerUri = tokenServerUri;
            return this;
        }

        public Builder setHttpTransportFactory(HttpTransportFactory transportFactory) {
            this.transportFactory = transportFactory;
            return this;
        }

        public Builder setQuotaProjectId(String quotaProjectId) {
            this.quotaProjectId = quotaProjectId;
            return this;
        }

        public Builder setLifetime(int lifetime) {
            this.lifetime = lifetime == 0 ? 3600 : lifetime;
            return this;
        }

        public Builder setUseJwtAccessWithScope(boolean useJwtAccessWithScope) {
            this.useJwtAccessWithScope = useJwtAccessWithScope;
            return this;
        }

        public Builder setDefaultRetriesEnabled(boolean defaultRetriesEnabled) {
            this.defaultRetriesEnabled = defaultRetriesEnabled;
            return this;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getClientEmail() {
            return this.clientEmail;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public String getPrivateKeyId() {
            return this.privateKeyId;
        }

        public Collection<String> getScopes() {
            return this.scopes;
        }

        public Collection<String> getDefaultScopes() {
            return this.defaultScopes;
        }

        public String getServiceAccountUser() {
            return this.serviceAccountUser;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public URI getTokenServerUri() {
            return this.tokenServerUri;
        }

        public HttpTransportFactory getHttpTransportFactory() {
            return this.transportFactory;
        }

        public String getQuotaProjectId() {
            return this.quotaProjectId;
        }

        public int getLifetime() {
            return this.lifetime;
        }

        public boolean getUseJwtAccessWithScope() {
            return this.useJwtAccessWithScope;
        }

        public boolean isDefaultRetriesEnabled() {
            return this.defaultRetriesEnabled;
        }

        @Override
        public ServiceAccountCredentials build() {
            return new ServiceAccountCredentials(this);
        }
    }
}

