/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import java.util.Arrays;
import java.util.Random;

public class ArraySortBenchmark {
    @Param(value={"10", "100", "1000", "10000"})
    private int length;
    @Param
    private Distribution distribution;
    private int[] values;
    private int[] copy;

    @BeforeExperiment
    void setUp() throws Exception {
        this.values = this.distribution.create(this.length);
        this.copy = new int[this.length];
    }

    @Benchmark
    void sort(int reps) {
        for (int i = 0; i < reps; ++i) {
            System.arraycopy(this.values, 0, this.copy, 0, this.values.length);
            Arrays.sort(this.copy);
        }
    }

    public static enum Distribution {
        SAWTOOTH{

            @Override
            int[] create(int length) {
                int[] result = new int[length];
                for (int i = 0; i < length; i += 5) {
                    result[i] = 0;
                    result[i + 1] = 1;
                    result[i + 2] = 2;
                    result[i + 3] = 3;
                    result[i + 4] = 4;
                }
                return result;
            }
        }
        ,
        INCREASING{

            @Override
            int[] create(int length) {
                int[] result = new int[length];
                for (int i = 0; i < length; ++i) {
                    result[i] = i;
                }
                return result;
            }
        }
        ,
        DECREASING{

            @Override
            int[] create(int length) {
                int[] result = new int[length];
                for (int i = 0; i < length; ++i) {
                    result[i] = length - i;
                }
                return result;
            }
        }
        ,
        RANDOM{

            @Override
            int[] create(int length) {
                Random random = new Random();
                int[] result = new int[length];
                for (int i = 0; i < length; ++i) {
                    result[i] = random.nextInt();
                }
                return result;
            }
        };


        abstract int[] create(int var1);
    }
}

