/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import java.util.BitSet;
import java.util.Random;

public class BitSetBenchmark {
    private BitSet bitSet;
    private char[] bitString;

    @BeforeExperiment
    void setUp() throws Exception {
        this.bitSet = new BitSet(64);
        this.bitString = new char[64];
        Random r = new Random();
        for (int n = 0; n < 64; ++n) {
            this.bitString[n] = r.nextBoolean() ? 49 : 48;
        }
    }

    @Benchmark
    int setBitSetX64(int reps) {
        long count = 64L * (long)reps;
        int i = 0;
        while ((long)i < count) {
            this.bitSet.set(i & 0x3F, true);
            ++i;
        }
        return this.bitSet.hashCode();
    }

    @Benchmark
    long setMaskX64(int reps) {
        long count = 64L * (long)reps;
        long bitMask = 0L;
        int i = 0;
        while ((long)i < count) {
            bitMask |= (long)(1 << (i & 0x3F));
            ++i;
        }
        return bitMask;
    }

    @Benchmark
    String charsToBitSet(int reps) {
        for (int i = 0; i < reps; ++i) {
            for (int n = 0; n < this.bitString.length; ++n) {
                this.bitSet.set(n, this.bitString[n] == '1');
            }
        }
        return this.bitSet.toString();
    }

    @Benchmark
    long charsToMask(int reps) {
        long bitMask = 0L;
        for (int i = 0; i < reps; ++i) {
            for (int n = 0; n < this.bitString.length; ++n) {
                long m = 1 << n;
                if (this.bitString[n] == '1') {
                    bitMask |= m;
                    continue;
                }
                bitMask &= m ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        return bitMask;
    }

    @Benchmark
    long baselineIteration(int reps) {
        int badHash = 0;
        for (int i = 0; i < reps; ++i) {
            for (int n = 0; n < this.bitString.length; ++n) {
                badHash += this.bitString[n];
            }
        }
        return badHash;
    }
}

