/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;

public class CharacterBenchmark {
    @Param
    private CharacterSet characterSet;
    @Param
    private Overload overload;
    private char[] chars;

    @BeforeExperiment
    void setUp() throws Exception {
        this.chars = this.characterSet.chars;
    }

    @Benchmark
    boolean isSpace(int reps) {
        boolean dummy = false;
        if (this.overload == Overload.CHAR) {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    dummy ^= (char)ch == ' ';
                }
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    dummy ^= ch == 32;
                }
            }
        }
        return dummy;
    }

    @Benchmark
    void digit(int reps) {
        if (this.overload == Overload.CHAR) {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.digit(this.chars[ch], 10);
                }
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.digit((int)this.chars[ch], 10);
                }
            }
        }
    }

    @Benchmark
    void getNumericValue(int reps) {
        if (this.overload == Overload.CHAR) {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.getNumericValue(this.chars[ch]);
                }
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.getNumericValue((int)this.chars[ch]);
                }
            }
        }
    }

    @Benchmark
    void isDigit(int reps) {
        if (this.overload == Overload.CHAR) {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isDigit(this.chars[ch]);
                }
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isDigit((int)this.chars[ch]);
                }
            }
        }
    }

    @Benchmark
    void isIdentifierIgnorable(int reps) {
        if (this.overload == Overload.CHAR) {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isIdentifierIgnorable(this.chars[ch]);
                }
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isIdentifierIgnorable((int)this.chars[ch]);
                }
            }
        }
    }

    @Benchmark
    void isJavaIdentifierPart(int reps) {
        if (this.overload == Overload.CHAR) {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isJavaIdentifierPart(this.chars[ch]);
                }
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isJavaIdentifierPart((int)this.chars[ch]);
                }
            }
        }
    }

    @Benchmark
    void isJavaIdentifierStart(int reps) {
        if (this.overload == Overload.CHAR) {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isJavaIdentifierStart(this.chars[ch]);
                }
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isJavaIdentifierStart((int)this.chars[ch]);
                }
            }
        }
    }

    @Benchmark
    void isLetter(int reps) {
        if (this.overload == Overload.CHAR) {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isLetter(this.chars[ch]);
                }
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isLetter((int)this.chars[ch]);
                }
            }
        }
    }

    @Benchmark
    void isLetterOrDigit(int reps) {
        if (this.overload == Overload.CHAR) {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isLetterOrDigit(this.chars[ch]);
                }
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isLetterOrDigit((int)this.chars[ch]);
                }
            }
        }
    }

    @Benchmark
    void isLowerCase(int reps) {
        if (this.overload == Overload.CHAR) {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isLowerCase(this.chars[ch]);
                }
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isLowerCase((int)this.chars[ch]);
                }
            }
        }
    }

    @Benchmark
    void isSpaceChar(int reps) {
        if (this.overload == Overload.CHAR) {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isSpaceChar(this.chars[ch]);
                }
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isSpaceChar((int)this.chars[ch]);
                }
            }
        }
    }

    @Benchmark
    void isUpperCase(int reps) {
        if (this.overload == Overload.CHAR) {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isUpperCase(this.chars[ch]);
                }
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isUpperCase((int)this.chars[ch]);
                }
            }
        }
    }

    @Benchmark
    void isWhitespace(int reps) {
        if (this.overload == Overload.CHAR) {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isWhitespace(this.chars[ch]);
                }
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.isWhitespace((int)this.chars[ch]);
                }
            }
        }
    }

    @Benchmark
    void toLowerCase(int reps) {
        if (this.overload == Overload.CHAR) {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.toLowerCase(this.chars[ch]);
                }
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.toLowerCase((int)this.chars[ch]);
                }
            }
        }
    }

    @Benchmark
    void toUpperCase(int reps) {
        if (this.overload == Overload.CHAR) {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.toUpperCase(this.chars[ch]);
                }
            }
        } else {
            for (int i = 0; i < reps; ++i) {
                for (int ch = 0; ch < 65536; ++ch) {
                    Character.toUpperCase((int)this.chars[ch]);
                }
            }
        }
    }

    public static enum CharacterSet {
        ASCII(128),
        UNICODE(65536);

        final char[] chars = new char[65536];

        private CharacterSet(int size) {
            for (int i = 0; i < 65536; ++i) {
                this.chars[i] = (char)(i % size);
            }
        }
    }

    public static enum Overload {
        CHAR,
        INT;

    }
}

