/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.caliper.model.ArbitraryMeasurement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;

public class CompressionSizeBenchmark {
    @Param(value={"this string will compress badly", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "asdfasdfasdfasdfasdfasdfasdfasdfasdfasdfasdfasdfasdfasdfasdfasdfasdfasdf"})
    private String toCompress;
    @Param(value={"bestCompression", "bestSpeed", "noCompression", "huffmanOnly"})
    private String compressionLevel;
    private double compressionRatio;
    public static final Map<String, Integer> compressionLevelMap = new HashMap<String, Integer>();

    @Benchmark
    long simpleCompression(int reps) {
        long dummy = 0L;
        for (int i = 0; i < reps; ++i) {
            dummy += (long)this.compress(this.toCompress.getBytes()).length;
        }
        return dummy;
    }

    @ArbitraryMeasurement(units=":1", description="ratio of uncompressed to compressed")
    public double compressionSize() {
        byte[] initialBytes = this.toCompress.getBytes();
        byte[] finalBytes = this.compress(initialBytes);
        this.compressionRatio = (double)initialBytes.length / (double)finalBytes.length;
        return this.compressionRatio;
    }

    private byte[] compress(byte[] bytes) {
        Deflater compressor = new Deflater();
        compressor.setLevel(compressionLevelMap.get(this.compressionLevel));
        compressor.setInput(bytes);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    static {
        compressionLevelMap.put("bestCompression", 9);
        compressionLevelMap.put("bestSpeed", 1);
        compressionLevelMap.put("noCompression", 0);
        compressionLevelMap.put("huffmanOnly", 2);
    }
}

