/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class ContainsBenchmark {
    @Param(value={"0", "25", "50", "75", "100"})
    private int percentNulls;
    @Param(value={"100", "1000", "10000"})
    private int containsPerRep;
    private final Set<String> set = new HashSet<String>();
    private final List<Object> queries = new ArrayList<Object>();

    @BeforeExperiment
    void setUp() {
        int i;
        this.set.addAll(Arrays.asList("str1", "str2", "str3", "str4"));
        int nullThreshold = this.percentNulls * this.containsPerRep / 100;
        for (i = 0; i < nullThreshold; ++i) {
            this.queries.add(null);
        }
        for (i = nullThreshold; i < this.containsPerRep; ++i) {
            this.queries.add(new Object());
        }
        Collections.shuffle(this.queries, new Random(0L));
    }

    @Benchmark
    void contains(int reps) {
        for (int i = 0; i < reps; ++i) {
            for (Object query : this.queries) {
                boolean bl = this.set.contains(query);
            }
        }
    }
}

