/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import java.util.Arrays;
import java.util.Random;

public class CopyArrayBenchmark {
    @Param
    Strategy strategy;
    @Param(value={"5", "500", "50000"})
    int size;
    Object[] objectArray;
    boolean[] booleanArray;
    byte[] byteArray;
    char[] charArray;
    double[] doubleArray;
    float[] floatArray;
    int[] intArray;
    long[] longArray;
    short[] shortArray;

    @BeforeExperiment
    void setUp() {
        this.objectArray = new Object[this.size];
        this.booleanArray = new boolean[this.size];
        this.byteArray = new byte[this.size];
        this.charArray = new char[this.size];
        this.doubleArray = new double[this.size];
        this.floatArray = new float[this.size];
        this.intArray = new int[this.size];
        this.longArray = new long[this.size];
        this.shortArray = new short[this.size];
        Random random = new Random();
        for (int i = 0; i < this.size; ++i) {
            int num = random.nextInt();
            this.objectArray[i] = new Object();
            this.booleanArray[i] = num % 2 == 0;
            this.byteArray[i] = (byte)num;
            this.charArray[i] = (char)num;
            this.doubleArray[i] = num;
            this.floatArray[i] = num;
            this.intArray[i] = num;
            this.longArray[i] = num;
            this.shortArray[i] = (short)num;
        }
    }

    @Benchmark
    int objects(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += System.identityHashCode(this.strategy.copy(this.objectArray));
        }
        return dummy;
    }

    @Benchmark
    int booleans(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += System.identityHashCode(this.strategy.copy(this.booleanArray));
        }
        return dummy;
    }

    @Benchmark
    int bytes(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += System.identityHashCode(this.strategy.copy(this.byteArray));
        }
        return dummy;
    }

    @Benchmark
    int chars(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += System.identityHashCode(this.strategy.copy(this.charArray));
        }
        return dummy;
    }

    @Benchmark
    int doubles(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += System.identityHashCode(this.strategy.copy(this.doubleArray));
        }
        return dummy;
    }

    @Benchmark
    int floats(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += System.identityHashCode(this.strategy.copy(this.floatArray));
        }
        return dummy;
    }

    @Benchmark
    int ints(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += System.identityHashCode(this.strategy.copy(this.intArray));
        }
        return dummy;
    }

    @Benchmark
    int longs(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += System.identityHashCode(this.strategy.copy(this.longArray));
        }
        return dummy;
    }

    @Benchmark
    int shorts(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += System.identityHashCode(this.strategy.copy(this.shortArray));
        }
        return dummy;
    }

    public static enum Strategy {
        CLONE{

            @Override
            Object[] copy(Object[] array) {
                return (Object[])array.clone();
            }

            @Override
            boolean[] copy(boolean[] array) {
                return (boolean[])array.clone();
            }

            @Override
            byte[] copy(byte[] array) {
                return (byte[])array.clone();
            }

            @Override
            char[] copy(char[] array) {
                return (char[])array.clone();
            }

            @Override
            double[] copy(double[] array) {
                return (double[])array.clone();
            }

            @Override
            float[] copy(float[] array) {
                return (float[])array.clone();
            }

            @Override
            int[] copy(int[] array) {
                return (int[])array.clone();
            }

            @Override
            long[] copy(long[] array) {
                return (long[])array.clone();
            }

            @Override
            short[] copy(short[] array) {
                return (short[])array.clone();
            }
        }
        ,
        ARRAYS_COPYOF{

            @Override
            Object[] copy(Object[] array) {
                return Arrays.copyOf(array, array.length);
            }

            @Override
            boolean[] copy(boolean[] array) {
                return Arrays.copyOf(array, array.length);
            }

            @Override
            byte[] copy(byte[] array) {
                return Arrays.copyOf(array, array.length);
            }

            @Override
            char[] copy(char[] array) {
                return Arrays.copyOf(array, array.length);
            }

            @Override
            double[] copy(double[] array) {
                return Arrays.copyOf(array, array.length);
            }

            @Override
            float[] copy(float[] array) {
                return Arrays.copyOf(array, array.length);
            }

            @Override
            int[] copy(int[] array) {
                return Arrays.copyOf(array, array.length);
            }

            @Override
            long[] copy(long[] array) {
                return Arrays.copyOf(array, array.length);
            }

            @Override
            short[] copy(short[] array) {
                return Arrays.copyOf(array, array.length);
            }
        }
        ,
        SYSTEM_ARRAYCOPY{

            @Override
            Object[] copy(Object[] array) {
                Object[] copy = new Object[array.length];
                System.arraycopy(array, 0, copy, 0, array.length);
                return copy;
            }

            @Override
            boolean[] copy(boolean[] array) {
                boolean[] copy = new boolean[array.length];
                System.arraycopy(array, 0, copy, 0, array.length);
                return copy;
            }

            @Override
            byte[] copy(byte[] array) {
                byte[] copy = new byte[array.length];
                System.arraycopy(array, 0, copy, 0, array.length);
                return copy;
            }

            @Override
            char[] copy(char[] array) {
                char[] copy = new char[array.length];
                System.arraycopy(array, 0, copy, 0, array.length);
                return copy;
            }

            @Override
            double[] copy(double[] array) {
                double[] copy = new double[array.length];
                System.arraycopy(array, 0, copy, 0, array.length);
                return copy;
            }

            @Override
            float[] copy(float[] array) {
                float[] copy = new float[array.length];
                System.arraycopy(array, 0, copy, 0, array.length);
                return copy;
            }

            @Override
            int[] copy(int[] array) {
                int[] copy = new int[array.length];
                System.arraycopy(array, 0, copy, 0, array.length);
                return copy;
            }

            @Override
            long[] copy(long[] array) {
                long[] copy = new long[array.length];
                System.arraycopy(array, 0, copy, 0, array.length);
                return copy;
            }

            @Override
            short[] copy(short[] array) {
                short[] copy = new short[array.length];
                System.arraycopy(array, 0, copy, 0, array.length);
                return copy;
            }
        }
        ,
        LOOP{

            @Override
            Object[] copy(Object[] array) {
                int len = array.length;
                Object[] copy = new Object[len];
                for (int i = 0; i < len; ++i) {
                    copy[i] = array[i];
                }
                return copy;
            }

            @Override
            boolean[] copy(boolean[] array) {
                int len = array.length;
                boolean[] copy = new boolean[array.length];
                for (int i = 0; i < len; ++i) {
                    copy[i] = array[i];
                }
                return copy;
            }

            @Override
            byte[] copy(byte[] array) {
                int len = array.length;
                byte[] copy = new byte[array.length];
                for (int i = 0; i < len; ++i) {
                    copy[i] = array[i];
                }
                return copy;
            }

            @Override
            char[] copy(char[] array) {
                int len = array.length;
                char[] copy = new char[array.length];
                for (int i = 0; i < len; ++i) {
                    copy[i] = array[i];
                }
                return copy;
            }

            @Override
            double[] copy(double[] array) {
                int len = array.length;
                double[] copy = new double[array.length];
                for (int i = 0; i < len; ++i) {
                    copy[i] = array[i];
                }
                return copy;
            }

            @Override
            float[] copy(float[] array) {
                int len = array.length;
                float[] copy = new float[array.length];
                for (int i = 0; i < len; ++i) {
                    copy[i] = array[i];
                }
                return copy;
            }

            @Override
            int[] copy(int[] array) {
                int len = array.length;
                int[] copy = new int[array.length];
                for (int i = 0; i < len; ++i) {
                    copy[i] = array[i];
                }
                return copy;
            }

            @Override
            long[] copy(long[] array) {
                int len = array.length;
                long[] copy = new long[array.length];
                for (int i = 0; i < len; ++i) {
                    copy[i] = array[i];
                }
                return copy;
            }

            @Override
            short[] copy(short[] array) {
                int len = array.length;
                short[] copy = new short[array.length];
                for (int i = 0; i < len; ++i) {
                    copy[i] = array[i];
                }
                return copy;
            }
        };


        abstract Object[] copy(Object[] var1);

        abstract boolean[] copy(boolean[] var1);

        abstract byte[] copy(byte[] var1);

        abstract char[] copy(char[] var1);

        abstract double[] copy(double[] var1);

        abstract float[] copy(float[] var1);

        abstract int[] copy(int[] var1);

        abstract long[] copy(long[] var1);

        abstract short[] copy(short[] var1);
    }
}

