/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.caliper.Benchmark;
import com.google.caliper.Param;

public class DoubleToStringBenchmark {
    @Param
    Method method;
    @Param
    Value value;

    @Benchmark
    int primitive(int reps) {
        double d = this.value.value;
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += this.method.convert(d).length();
        }
        return dummy;
    }

    @Benchmark
    int wrapper(int reps) {
        Double d = this.value.value;
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            dummy += this.method.convert(d).length();
        }
        return dummy;
    }

    static enum Value {
        Pi(Math.PI),
        NegativeZero(-0.0),
        NegativeInfinity(Double.NEGATIVE_INFINITY),
        NaN(Double.NaN);

        final double value;

        private Value(double value) {
            this.value = value;
        }
    }

    public static enum Method {
        TO_STRING{

            @Override
            String convert(double d) {
                return Double.valueOf(d).toString();
            }

            @Override
            String convert(Double d) {
                return d.toString();
            }
        }
        ,
        STRING_VALUE_OF{

            @Override
            String convert(double d) {
                return String.valueOf(d);
            }

            @Override
            String convert(Double d) {
                return String.valueOf(d);
            }
        }
        ,
        STRING_FORMAT{

            @Override
            String convert(double d) {
                return String.format("%f", d);
            }

            @Override
            String convert(Double d) {
                return String.format("%f", d);
            }
        }
        ,
        QUOTE_TRICK{

            @Override
            String convert(double d) {
                return new StringBuilder(24).append(d).toString();
            }

            @Override
            String convert(Double d) {
                String string = String.valueOf(d);
                return new StringBuilder(String.valueOf(string).length()).append(string).toString();
            }
        };


        abstract String convert(double var1);

        abstract String convert(Double var1);
    }
}

