/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.caliper.Benchmark;
import com.google.caliper.Param;

public class DoubleToStringBenchmark2 {
    @Param
    boolean useWrapper;
    @Param
    Value value;

    @Benchmark
    int toString(int reps) {
        int dummy = 0;
        if (this.useWrapper) {
            Double d = this.value.d;
            for (int i = 0; i < reps; ++i) {
                dummy += d.toString().length();
            }
        } else {
            double d = this.value.d;
            for (int i = 0; i < reps; ++i) {
                dummy += Double.valueOf(d).toString().length();
            }
        }
        return dummy;
    }

    @Benchmark
    int stringValueOf(int reps) {
        int dummy = 0;
        if (this.useWrapper) {
            Double d = this.value.d;
            for (int i = 0; i < reps; ++i) {
                dummy += String.valueOf(d).length();
            }
        } else {
            double d = this.value.d;
            for (int i = 0; i < reps; ++i) {
                dummy += String.valueOf(d).length();
            }
        }
        return dummy;
    }

    @Benchmark
    int stringFormat(int reps) {
        int dummy = 0;
        if (this.useWrapper) {
            Double d = this.value.d;
            for (int i = 0; i < reps; ++i) {
                dummy += String.format("%f", d).length();
            }
        } else {
            double d = this.value.d;
            for (int i = 0; i < reps; ++i) {
                dummy += String.format("%f", d).length();
            }
        }
        return dummy;
    }

    @Benchmark
    int quoteTrick(int reps) {
        int dummy = 0;
        if (this.useWrapper) {
            Double d = this.value.d;
            for (int i = 0; i < reps; ++i) {
                String string = String.valueOf(d);
                dummy += new StringBuilder(String.valueOf(string).length()).append(string).toString().length();
            }
        } else {
            double d = this.value.d;
            for (int i = 0; i < reps; ++i) {
                dummy += new StringBuilder(24).append(d).toString().length();
            }
        }
        return dummy;
    }

    static enum Value {
        Pi(Math.PI),
        NegativeZero(-0.0),
        NegativeInfinity(Double.NEGATIVE_INFINITY),
        NaN(Double.NaN);

        final double d;

        private Value(double d) {
            this.d = d;
        }
    }
}

