/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.caliper.Benchmark;
import java.util.Formatter;

public class FormatterBenchmark {
    @Benchmark
    void formatter_NoFormatting(int reps) {
        for (int i = 0; i < reps; ++i) {
            Formatter f = new Formatter();
            f.format("this is a reasonably short string that doesn't actually need any formatting", new Object[0]);
            f.close();
        }
    }

    @Benchmark
    void stringBuilder_NoFormatting(int reps) {
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append("this is a reasonably short string that doesn't actually need any formatting");
        }
    }

    @Benchmark
    void formatter_OneInt(int reps) {
        for (int i = 0; i < reps; ++i) {
            Formatter f = new Formatter();
            f.format("this is a reasonably short string that has an int %d in it", i);
            f.close();
        }
    }

    @Benchmark
    void stringBuilder_OneInt(int reps) {
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append("this is a reasonably short string that has an int ");
            sb.append(i);
            sb.append(" in it");
        }
    }

    @Benchmark
    void formatter_OneString(int reps) {
        for (int i = 0; i < reps; ++i) {
            Formatter f = new Formatter();
            f.format("this is a reasonably short string that has a string %s in it", "hello");
            f.close();
        }
    }

    @Benchmark
    void stringBuilder_OneString(int reps) {
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append("this is a reasonably short string that has a string ");
            sb.append("hello");
            sb.append(" in it");
        }
    }
}

