/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.caliper.Benchmark;

public class IntModBenchmark {
    private static final int M = 65535;

    @Benchmark
    int conditional(int reps) {
        int dummy = 5;
        for (int i = 0; i < reps; ++i) {
            dummy += Integer.MAX_VALUE + IntModBenchmark.conditionalMod(dummy, 65535);
        }
        return dummy;
    }

    private static int conditionalMod(int a, int m) {
        int r = a % m;
        return r < 0 ? r + m : r;
    }

    @Benchmark
    int doubleRemainder(int reps) {
        int dummy = 5;
        for (int i = 0; i < reps; ++i) {
            dummy += Integer.MAX_VALUE + IntModBenchmark.doubleRemainderMod(dummy, 65535);
        }
        return dummy;
    }

    private static int doubleRemainderMod(int a, int m) {
        return (int)(((long)(a % m) + (long)m) % (long)m);
    }

    @Benchmark
    int rightShiftingMod(int reps) {
        int dummy = 5;
        for (int i = 0; i < reps; ++i) {
            dummy += Integer.MAX_VALUE + IntModBenchmark.rightShiftingMod(dummy, 65535);
        }
        return dummy;
    }

    private static int rightShiftingMod(int a, int m) {
        long r = a % m;
        return (int)(r + (r >> 63 & (long)m));
    }

    @Benchmark
    int leftShiftingMod(int reps) {
        int dummy = 5;
        for (int i = 0; i < reps; ++i) {
            dummy += Integer.MAX_VALUE + IntModBenchmark.leftShiftingMod(dummy, 65535);
        }
        return dummy;
    }

    private static int leftShiftingMod(int a, int m) {
        return (int)(((long)a + ((long)m << 32)) % (long)m);
    }

    @Benchmark
    int wrongMod(int reps) {
        int dummy = 5;
        for (int i = 0; i < reps; ++i) {
            dummy += Integer.MAX_VALUE + dummy % 65535;
        }
        return dummy;
    }
}

