/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import java.util.AbstractList;
import java.util.List;

public class ListIterationBenchmark {
    @Param(value={"0", "10", "100", "1000"})
    private int length;
    private List<Object> list;
    private Object[] array;

    @BeforeExperiment
    void setUp() {
        this.array = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.array[i] = new Object();
        }
        this.list = new AbstractList<Object>(){

            @Override
            public int size() {
                return ListIterationBenchmark.this.length;
            }

            @Override
            public Object get(int i) {
                return ListIterationBenchmark.this.array[i];
            }
        };
    }

    @Benchmark
    int listIteration(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            for (Object value : this.list) {
                dummy |= value.hashCode();
            }
        }
        return dummy;
    }

    @Benchmark
    int arrayIteration(int reps) {
        int dummy = 0;
        for (int i = 0; i < reps; ++i) {
            for (Object value : this.array) {
                dummy |= value.hashCode();
            }
        }
        return dummy;
    }
}

