/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ListModificationBenchmark {
    @Param(value={"10", "100", "1000", "10000"})
    private int size;
    @Param(value={"Array", "Linked"})
    private ListImpl implementation;
    private List<Element> list;

    @BeforeExperiment
    void setUp() throws Exception {
        this.list = this.implementation.create();
        for (int i = 0; i < this.size; ++i) {
            this.list.add(Element.INSTANCE);
        }
    }

    @Benchmark
    void populate(int reps) throws Exception {
        for (int rep = 0; rep < reps; ++rep) {
            List<Element> list = this.implementation.create();
            for (int i = 0; i < this.size; ++i) {
                list.add(Element.INSTANCE);
            }
        }
    }

    @Benchmark
    void iteration(int reps) {
        for (int rep = 0; rep < reps; ++rep) {
            Iterator<Element> iterator = this.list.iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
    }

    @Benchmark
    void headAddRemove(int reps) {
        for (int rep = 0; rep < reps; ++rep) {
            this.list.add(0, Element.INSTANCE);
            this.list.remove(0);
        }
    }

    @Benchmark
    void middleAddRemove(int reps) {
        int index = this.size / 2;
        for (int rep = 0; rep < reps; ++rep) {
            this.list.add(index, Element.INSTANCE);
            this.list.remove(index);
        }
    }

    @Benchmark
    void tailAddRemove(int reps) {
        int index = this.size - 1;
        for (int rep = 0; rep < reps; ++rep) {
            this.list.add(Element.INSTANCE);
            this.list.remove(index);
        }
    }

    private static enum ListImpl {
        Array{

            @Override
            List<Element> create() {
                return new ArrayList<Element>();
            }
        }
        ,
        Linked{

            @Override
            List<Element> create() {
                return new LinkedList<Element>();
            }
        };


        abstract List<Element> create();
    }

    private static enum Element {
        INSTANCE;

    }
}

