/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.caliper.Benchmark;
import com.google.caliper.Param;

public class StringBuilderBenchmark {
    @Param(value={"1", "10", "100"})
    private int length;

    @Benchmark
    void appendBoolean(int reps) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < reps; ++i) {
            sb.setLength(0);
            for (int j = 0; j < this.length; ++j) {
                sb.append(true);
                sb.append(false);
            }
        }
    }

    @Benchmark
    void appendChar(int reps) {
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.length; ++j) {
                sb.append('c');
            }
        }
    }

    @Benchmark
    void appendCharArray(int reps) {
        char[] chars = "chars".toCharArray();
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.length; ++j) {
                sb.append(chars);
            }
        }
    }

    @Benchmark
    void appendCharSequence(int reps) {
        String cs = "chars";
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.length; ++j) {
                sb.append((CharSequence)cs);
            }
        }
    }

    @Benchmark
    void appendDouble(int reps) {
        double d = 1.2;
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.length; ++j) {
                sb.append(d);
            }
        }
    }

    @Benchmark
    void appendFloat(int reps) {
        float f = 1.2f;
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.length; ++j) {
                sb.append(f);
            }
        }
    }

    @Benchmark
    void appendInt(int reps) {
        int n = 123;
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.length; ++j) {
                sb.append(n);
            }
        }
    }

    @Benchmark
    void appendLong(int reps) {
        long l = 123L;
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.length; ++j) {
                sb.append(l);
            }
        }
    }

    @Benchmark
    void appendObject(int reps) {
        Object o = new Object();
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.length; ++j) {
                sb.append(o);
            }
        }
    }

    @Benchmark
    void appendString(int reps) {
        String s = "chars";
        for (int i = 0; i < reps; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.length; ++j) {
                sb.append(s);
            }
        }
    }

    @Benchmark
    void appendNull(int reps) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < reps; ++i) {
            sb.setLength(0);
            for (int j = 0; j < this.length; ++j) {
                sb.append((String)null);
                sb.append((CharSequence)null);
            }
        }
    }

    @Benchmark
    void reverseNoSurrogates(int reps) {
        int length = Math.min(this.length, 55296);
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < length; ++j) {
            sb.appendCodePoint(j);
        }
        for (int i = 0; i < reps; ++i) {
            for (int j = 0; j < 4; ++j) {
                sb.reverse();
            }
            if (sb.codePointAt(0) <= 55296) continue;
            throw new Error();
        }
    }

    @Benchmark
    void codePointAtNoSurrogates(int reps) {
        int length = Math.min(this.length, 55296);
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < length; ++j) {
            sb.appendCodePoint(j);
        }
        for (int i = 0; i < reps; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < length - 1; ++k) {
                    if (sb.codePointAt(k) <= 55296) continue;
                    throw new Error();
                }
            }
        }
    }

    @Benchmark
    void codePointBeforeNoSurrogates(int reps) {
        int length = Math.min(this.length, 55296);
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < length; ++j) {
            sb.appendCodePoint(j);
        }
        for (int i = 0; i < reps; ++i) {
            for (int j = 0; j < 4; ++j) {
                for (int k = 1; k < length; ++k) {
                    if (sb.codePointBefore(k) <= 55296) continue;
                    throw new Error();
                }
            }
        }
    }
}

