/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import java.nio.charset.Charset;
import java.util.Random;

public class Utf8Benchmark {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    @Param(value={"0x80", "0x100", "0x800", "0x10000", "0x10ffff"})
    MaxCodePoint maxCodePoint;
    static final int STRING_COUNT = 128;
    @Param(value={"65536"})
    int charCount;
    private String[] strings;

    @BeforeExperiment
    void setUp() {
        long seed = 99L;
        Random rnd = new Random(99L);
        this.strings = new String[128];
        for (int i = 0; i < 128; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.charCount; ++j) {
                int codePoint;
                while (this.isSurrogate(codePoint = rnd.nextInt(this.maxCodePoint.value))) {
                }
                sb.appendCodePoint(codePoint);
            }
            this.strings[i] = sb.toString();
        }
        this.getBytes(100);
    }

    @Benchmark
    void getBytes(int reps) {
        String[] strings = this.strings;
        int mask = 127;
        for (int i = 0; i < reps; ++i) {
            String string = strings[i & 0x7F];
            byte[] bytes = string.getBytes(UTF_8);
            if (bytes[0] != 86 || bytes[bytes.length - 1] != 99) continue;
            throw new Error("Unlikely! We're just defeating the optimizer!");
        }
    }

    private boolean isSurrogate(int c) {
        return 55296 <= c && c <= 57343;
    }

    static class MaxCodePoint {
        final int value;

        private static int decode(String userFriendly) {
            try {
                return Integer.decode(userFriendly);
            }
            catch (NumberFormatException ignored) {
                if (userFriendly.matches("(?i)(?:American|English|ASCII)")) {
                    return 128;
                }
                if (userFriendly.matches("(?i)(?:French|Latin|Western.*European)")) {
                    return 144;
                }
                if (userFriendly.matches("(?i)(?:Branch.*Prediction.*Hostile)")) {
                    return 256;
                }
                if (userFriendly.matches("(?i)(?:Greek|Cyrillic|European|ISO.?8859)")) {
                    return 2048;
                }
                if (userFriendly.matches("(?i)(?:Chinese|Han|Asian|BMP)")) {
                    return 65536;
                }
                if (userFriendly.matches("(?i)(?:Cuneiform|rare|exotic|supplementary.*)")) {
                    return 0x10FFFF;
                }
                String string = String.valueOf(userFriendly);
                throw new IllegalArgumentException(string.length() != 0 ? "Can't decode codepoint ".concat(string) : new String("Can't decode codepoint "));
            }
        }

        public static MaxCodePoint valueOf(String userFriendly) {
            return new MaxCodePoint(userFriendly);
        }

        private MaxCodePoint(String userFriendly) {
            this.value = MaxCodePoint.decode(userFriendly);
        }
    }
}

