/*
 * Decompiled with CFR 0.152.
 */
package examples;

import com.google.caliper.BeforeExperiment;
import com.google.caliper.Benchmark;
import com.google.caliper.Param;
import com.google.caliper.api.SkipThisScenarioException;
import java.util.Random;

public final class VarargsBenchmark {
    @Param
    private Strategy strategy;
    @Param(value={"1", "2", "3", "4", "5", "6"})
    private int arguments;
    private long[] data = new long[2048];

    private static long varargs(long ... longs) {
        long result = 0L;
        for (long i : longs) {
            result ^= i;
        }
        return result;
    }

    private static long one(long a) {
        return a;
    }

    private static long two(long a, long b) {
        return a ^ b;
    }

    private static long three(long a, long b, long c) {
        return a ^ b ^ c;
    }

    private static long four(long a, long b, long c, long d) {
        return a ^ b ^ c ^ d;
    }

    private static long five(long a, long b, long c, long d, long e) {
        return a ^ b ^ c ^ d ^ e;
    }

    private static long six(long a, long b, long c, long d, long e, long f) {
        return a ^ b ^ c ^ d ^ e ^ f;
    }

    @BeforeExperiment
    void setUp() {
        Random random = new Random();
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = random.nextLong();
        }
    }

    @Benchmark
    long invocation(int reps) {
        switch (this.arguments) {
            case 1: {
                return this.oneArgument(reps);
            }
            case 2: {
                return this.twoArguments(reps);
            }
            case 3: {
                return this.threeArguments(reps);
            }
            case 4: {
                return this.fourArguments(reps);
            }
            case 5: {
                return this.fiveArguments(reps);
            }
            case 6: {
                return this.sixArguments(reps);
            }
        }
        throw new SkipThisScenarioException();
    }

    private long oneArgument(int reps) {
        long dummy = 0L;
        long[] data = this.data;
        int dataLength = data.length;
        for (int i = 0; i < reps; ++i) {
            dummy += this.strategy.one(data[i % dataLength]);
        }
        return dummy;
    }

    private long twoArguments(int reps) {
        long dummy = 0L;
        long[] data = this.data;
        int dataLength = data.length;
        for (int i = 0; i < reps; ++i) {
            dummy += this.strategy.two(data[i % dataLength], data[(i + 1) % dataLength]);
        }
        return dummy;
    }

    private long threeArguments(int reps) {
        long dummy = 0L;
        long[] data = this.data;
        int dataLength = data.length;
        for (int i = 0; i < reps; ++i) {
            dummy += this.strategy.three(data[i % dataLength], data[(i + 1) % dataLength], data[(i + 2) % dataLength]);
        }
        return dummy;
    }

    private long fourArguments(int reps) {
        long dummy = 0L;
        long[] data = this.data;
        int dataLength = data.length;
        for (int i = 0; i < reps; ++i) {
            dummy += this.strategy.four(data[i % dataLength], data[(i + 1) % dataLength], data[(i + 2) % dataLength], data[(i + 3) % dataLength]);
        }
        return dummy;
    }

    private long fiveArguments(int reps) {
        long dummy = 0L;
        long[] data = this.data;
        int dataLength = data.length;
        for (int i = 0; i < reps; ++i) {
            dummy += this.strategy.five(data[i % dataLength], data[(i + 1) % dataLength], data[(i + 2) % dataLength], data[(i + 3) % dataLength], data[(i + 4) % dataLength]);
        }
        return dummy;
    }

    private long sixArguments(int reps) {
        long dummy = 0L;
        long[] data = this.data;
        int dataLength = data.length;
        for (int i = 0; i < reps; ++i) {
            dummy += this.strategy.six(data[i % dataLength], data[(i + 1) % dataLength], data[(i + 2) % dataLength], data[(i + 3) % dataLength], data[(i + 4) % dataLength], data[(i + 5) % dataLength]);
        }
        return dummy;
    }

    static enum Strategy {
        VARARGS{

            @Override
            long one(long a) {
                return VarargsBenchmark.varargs(new long[]{a});
            }

            @Override
            long two(long a, long b) {
                return VarargsBenchmark.varargs(new long[]{a, b});
            }

            @Override
            long three(long a, long b, long c) {
                return VarargsBenchmark.varargs(new long[]{a, b, c});
            }

            @Override
            long four(long a, long b, long c, long d) {
                return VarargsBenchmark.varargs(new long[]{a, b, c, d});
            }

            @Override
            long five(long a, long b, long c, long d, long e) {
                return VarargsBenchmark.varargs(new long[]{a, b, c, d});
            }

            @Override
            long six(long a, long b, long c, long d, long e, long f) {
                return VarargsBenchmark.varargs(new long[]{a, b, c, d, e, f});
            }
        }
        ,
        EXPANSION{

            @Override
            long one(long a) {
                return VarargsBenchmark.one(a);
            }

            @Override
            long two(long a, long b) {
                return VarargsBenchmark.two(a, b);
            }

            @Override
            long three(long a, long b, long c) {
                return VarargsBenchmark.three(a, b, c);
            }

            @Override
            long four(long a, long b, long c, long d) {
                return VarargsBenchmark.four(a, b, c, d);
            }

            @Override
            long five(long a, long b, long c, long d, long e) {
                return VarargsBenchmark.five(a, b, c, d, e);
            }

            @Override
            long six(long a, long b, long c, long d, long e, long f) {
                return VarargsBenchmark.six(a, b, c, d, e, f);
            }
        };


        abstract long one(long var1);

        abstract long two(long var1, long var3);

        abstract long three(long var1, long var3, long var5);

        abstract long four(long var1, long var3, long var5, long var7);

        abstract long five(long var1, long var3, long var5, long var7, long var9);

        abstract long six(long var1, long var3, long var5, long var7, long var9, long var11);
    }
}

