package com.google.caliper.runner.config;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

// Generated by com.google.auto.value.processor.AutoValueProcessor
final class AutoValue_DeviceConfig extends DeviceConfig {

  private final String name;

  private final DeviceType type;

  private final ImmutableMap<String, String> options;

  private AutoValue_DeviceConfig(
      String name,
      DeviceType type,
      ImmutableMap<String, String> options) {
    this.name = name;
    this.type = type;
    this.options = options;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public DeviceType type() {
    return type;
  }

  @Override
  public ImmutableMap<String, String> options() {
    return options;
  }

  @Override
  public String toString() {
    return "DeviceConfig{"
        + "name=" + name + ", "
        + "type=" + type + ", "
        + "options=" + options
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DeviceConfig) {
      DeviceConfig that = (DeviceConfig) o;
      return this.name.equals(that.name())
          && this.type.equals(that.type())
          && this.options.equals(that.options());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= options.hashCode();
    return h$;
  }

  static final class Builder implements DeviceConfig.Builder {
    private String name;
    private DeviceType type;
    private ImmutableMap.Builder<String, String> optionsBuilder$;
    private ImmutableMap<String, String> options;
    Builder() {
    }
    @Override
    public DeviceConfig.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public DeviceConfig.Builder type(DeviceType type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public DeviceConfig.Builder options(Map<String, String> options) {
      if (optionsBuilder$ != null) {
        throw new IllegalStateException("Cannot set options after calling optionsBuilder()");
      }
      this.options = ImmutableMap.copyOf(options);
      return this;
    }
    @Override
    public ImmutableMap.Builder<String, String> optionsBuilder() {
      if (optionsBuilder$ == null) {
        if (options == null) {
          optionsBuilder$ = ImmutableMap.builder();
        } else {
          optionsBuilder$ = ImmutableMap.builder();
          optionsBuilder$.putAll(options);
          options = null;
        }
      }
      return optionsBuilder$;
    }
    @Override
    public DeviceConfig build() {
      if (optionsBuilder$ != null) {
        this.options = optionsBuilder$.build();
      } else if (this.options == null) {
        this.options = ImmutableMap.of();
      }
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (this.type == null) {
        missing += " type";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_DeviceConfig(
          this.name,
          this.type,
          this.options);
    }
  }

}
