package com.google.caliper.runner.config;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;

// Generated by com.google.auto.value.processor.AutoValueProcessor
final class AutoValue_VmConfig extends VmConfig {

  private final String name;

  private final Optional<VmType> type;

  private final Optional<String> home;

  private final Optional<String> executable;

  private final ImmutableList<String> args;

  private AutoValue_VmConfig(
      String name,
      Optional<VmType> type,
      Optional<String> home,
      Optional<String> executable,
      ImmutableList<String> args) {
    this.name = name;
    this.type = type;
    this.home = home;
    this.executable = executable;
    this.args = args;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public Optional<VmType> type() {
    return type;
  }

  @Override
  public Optional<String> home() {
    return home;
  }

  @Override
  public Optional<String> executable() {
    return executable;
  }

  @Override
  public ImmutableList<String> args() {
    return args;
  }

  @Override
  public String toString() {
    return "VmConfig{"
        + "name=" + name + ", "
        + "type=" + type + ", "
        + "home=" + home + ", "
        + "executable=" + executable + ", "
        + "args=" + args
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof VmConfig) {
      VmConfig that = (VmConfig) o;
      return this.name.equals(that.name())
          && this.type.equals(that.type())
          && this.home.equals(that.home())
          && this.executable.equals(that.executable())
          && this.args.equals(that.args());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    h$ *= 1000003;
    h$ ^= home.hashCode();
    h$ *= 1000003;
    h$ ^= executable.hashCode();
    h$ *= 1000003;
    h$ ^= args.hashCode();
    return h$;
  }

  static final class Builder extends VmConfig.Builder {
    private String name;
    private Optional<VmType> type = Optional.absent();
    private Optional<String> home = Optional.absent();
    private Optional<String> executable = Optional.absent();
    private ImmutableList.Builder<String> argsBuilder$;
    private ImmutableList<String> args;
    Builder() {
    }
    @Override
    public VmConfig.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public VmConfig.Builder type(VmType type) {
      this.type = Optional.of(type);
      return this;
    }
    @Override
    public VmConfig.Builder home(String home) {
      this.home = Optional.of(home);
      return this;
    }
    @Override
    public VmConfig.Builder executable(String executable) {
      this.executable = Optional.of(executable);
      return this;
    }
    @Override
    public ImmutableList.Builder<String> argsBuilder() {
      if (argsBuilder$ == null) {
        argsBuilder$ = ImmutableList.builder();
      }
      return argsBuilder$;
    }
    @Override
    public VmConfig build() {
      if (argsBuilder$ != null) {
        this.args = argsBuilder$.build();
      } else if (this.args == null) {
        this.args = ImmutableList.of();
      }
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_VmConfig(
          this.name,
          this.type,
          this.home,
          this.executable,
          this.args);
    }
  }

}
