/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.instrument;

import com.google.caliper.bridge.AbstractLogMessageVisitor;
import com.google.caliper.bridge.StopMeasurementLogMessage;
import com.google.caliper.core.BenchmarkClassModel;
import com.google.caliper.core.InvalidBenchmarkException;
import com.google.caliper.model.InstrumentSpec;
import com.google.caliper.model.InstrumentType;
import com.google.caliper.model.Measurement;
import com.google.caliper.runner.config.VmConfig;
import com.google.caliper.runner.instrument.InstrumentName;
import com.google.caliper.runner.instrument.InstrumentOptions;
import com.google.caliper.runner.instrument.MeasurementCollectingVisitor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;

public abstract class Instrument {
    protected ImmutableMap<String, String> options = ImmutableMap.of();
    private String name = this.getClass().getSimpleName();

    @Inject
    @VisibleForTesting
    public void setOptions(@InstrumentOptions ImmutableMap<String, String> options) {
        this.options = ImmutableMap.copyOf((Map)Maps.filterKeys(options, (Predicate)Predicates.in(this.instrumentOptions())));
    }

    @Inject
    void setInstrumentName(@InstrumentName String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    public abstract boolean isBenchmarkMethod(BenchmarkClassModel.MethodModel var1);

    public abstract InstrumentedMethod createInstrumentedMethod(BenchmarkClassModel.MethodModel var1) throws InvalidBenchmarkException;

    public boolean parallelizable() {
        return false;
    }

    public final ImmutableMap<String, String> options() {
        return this.options;
    }

    public final InstrumentSpec getSpec() {
        return new InstrumentSpec.Builder().instrumentClass(this.getClass()).addAllOptions(this.options()).build();
    }

    protected ImmutableSet<String> instrumentOptions() {
        return ImmutableSet.of();
    }

    public ImmutableSet<String> getExtraCommandLineArgs(VmConfig vmConfig) {
        return ImmutableSet.of();
    }

    protected static final class DefaultMeasurementCollectingVisitor
    extends AbstractLogMessageVisitor
    implements MeasurementCollectingVisitor {
        static final int DEFAULT_NUMBER_OF_MEASUREMENTS = 9;
        final ImmutableSet<String> requiredDescriptions;
        final ListMultimap<String, Measurement> measurementsByDescription;
        final int requiredMeasurements;

        DefaultMeasurementCollectingVisitor(ImmutableSet<String> requiredDescriptions) {
            this(requiredDescriptions, 9);
        }

        DefaultMeasurementCollectingVisitor(ImmutableSet<String> requiredDescriptions, int requiredMeasurements) {
            this.requiredDescriptions = requiredDescriptions;
            Preconditions.checkArgument((!requiredDescriptions.isEmpty() ? 1 : 0) != 0);
            this.requiredMeasurements = requiredMeasurements;
            Preconditions.checkArgument((requiredMeasurements > 0 ? 1 : 0) != 0);
            this.measurementsByDescription = MultimapBuilder.hashKeys((int)requiredDescriptions.size()).arrayListValues(requiredMeasurements).build();
        }

        public void visit(StopMeasurementLogMessage logMessage) {
            for (Measurement measurement : logMessage.measurements()) {
                this.measurementsByDescription.put((Object)measurement.description(), (Object)measurement);
            }
        }

        @Override
        public boolean isDoneCollecting() {
            for (String description : this.requiredDescriptions) {
                if (this.measurementsByDescription.get((Object)description).size() >= this.requiredMeasurements) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isWarmupComplete() {
            return true;
        }

        @Override
        public ImmutableList<Measurement> getMeasurements() {
            return ImmutableList.copyOf((Collection)this.measurementsByDescription.values());
        }

        @Override
        public ImmutableList<String> getMessages() {
            return ImmutableList.of();
        }
    }

    public abstract class InstrumentedMethod {
        protected BenchmarkClassModel.MethodModel benchmarkMethod;

        protected InstrumentedMethod(BenchmarkClassModel.MethodModel benchmarkMethod) {
            this.benchmarkMethod = (BenchmarkClassModel.MethodModel)Preconditions.checkNotNull((Object)benchmarkMethod);
        }

        public final Instrument instrument() {
            return Instrument.this;
        }

        public final BenchmarkClassModel.MethodModel benchmarkMethod() {
            return this.benchmarkMethod;
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof InstrumentedMethod) {
                InstrumentedMethod that = (InstrumentedMethod)obj;
                return Instrument.this.equals(that.instrument()) && this.benchmarkMethod.equals(that.benchmarkMethod);
            }
            return super.equals(obj);
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{Instrument.this, this.benchmarkMethod});
        }

        public final String toString() {
            return MoreObjects.toStringHelper(InstrumentedMethod.class).add("instrument", (Object)Instrument.this).add("benchmarkMethod", (Object)this.benchmarkMethod).toString();
        }

        public abstract InstrumentType type();

        public ImmutableMap<String, String> workerOptions() {
            return Instrument.this.options;
        }

        public abstract MeasurementCollectingVisitor getMeasurementCollectingVisitor();

        public Optional<String> validateMeasurements(Iterable<ImmutableList<Measurement>> results) {
            return Optional.absent();
        }
    }
}

