/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.target;

import com.google.caliper.runner.config.CaliperConfig;
import com.google.caliper.runner.config.DeviceConfig;
import com.google.caliper.runner.options.CaliperOptions;
import com.google.caliper.runner.target.AdbDevice;
import com.google.caliper.runner.target.Device;
import com.google.caliper.runner.target.LocalDevice;
import com.google.caliper.runner.target.RuntimeShutdownHookRegistrar;
import com.google.caliper.runner.target.ShutdownHookRegistrar;
import com.google.common.util.concurrent.Service;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoSet;
import javax.inject.Provider;

@Module
public abstract class DeviceModule {
    private DeviceModule() {
    }

    @Provides
    static DeviceConfig provideDeviceConfig(CaliperOptions options, CaliperConfig config) {
        return config.getDeviceConfig(options);
    }

    @Binds
    abstract ShutdownHookRegistrar bindShutdownHookRegistrar(RuntimeShutdownHookRegistrar var1);

    @Provides
    static Device provideDevice(DeviceConfig config, Provider<LocalDevice> localDeviceProvider, Provider<AdbDevice> adbDeviceProvider) {
        switch (config.type()) {
            case LOCAL: {
                return (Device)((Object)localDeviceProvider.get());
            }
            case ADB: {
                return (Device)((Object)adbDeviceProvider.get());
            }
        }
        throw new AssertionError(config);
    }

    @Binds
    @IntoSet
    abstract Service bindDeviceAsService(Device var1);
}

