/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker;

import com.google.auto.value.AutoValue;
import com.google.caliper.runner.worker.AutoValue_Command;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

@AutoValue
public abstract class Command {
    private static final Joiner SPACE_JOINER = Joiner.on((char)' ');

    public static Builder builder() {
        return new AutoValue_Command.Builder();
    }

    public abstract ImmutableMap<String, String> environment();

    public abstract ImmutableList<String> arguments();

    public final String argumentsString() {
        return SPACE_JOINER.join(this.arguments());
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)Command.class.getSimpleName()).add("environment", this.environment()).add("arguments", (Object)this.argumentsString()).toString();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public final Builder addArgument(Object arg) {
            this.argumentsBuilder().add((Object)arg.toString());
            return this;
        }

        public final Builder addArguments(Iterable<?> args) {
            for (Object arg : args) {
                this.argumentsBuilder().add((Object)arg.toString());
            }
            return this;
        }

        abstract ImmutableList.Builder<String> argumentsBuilder();

        public final Builder putEnvironmentVariable(String key, String value) {
            this.environmentBuilder().put((Object)key, (Object)value);
            return this;
        }

        public final Builder putAllEnvironmentVariables(Map<String, String> variables) {
            this.environmentBuilder().putAll(variables);
            return this;
        }

        abstract ImmutableMap.Builder<String, String> environmentBuilder();

        abstract Command build();
    }
}

