/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.runner.worker;

import com.google.caliper.bridge.LogMessage;
import com.google.caliper.runner.worker.Worker;
import com.google.caliper.runner.worker.WorkerException;
import com.google.caliper.util.ShortDuration;
import java.io.IOException;
import javax.annotation.Nullable;

public abstract class WorkerProcessor<R> {
    public abstract ShortDuration timeLimit();

    public abstract boolean handleMessage(LogMessage var1, Worker var2) throws IOException;

    public String getInterruptionErrorMessage(Worker worker) {
        return String.format("Worker [%s] cancelled.", worker.name());
    }

    public String getPrematureExitErrorMessage(Worker worker) {
        return String.format("Worker [%s] exited without producing data. It has likely crashed.", worker.name());
    }

    public String getTimeoutErrorMessage(Worker worker) {
        return String.format("Worker [%s] exceeded the total allowable runtime.", worker.name());
    }

    public WorkerException newWorkerException(String message, @Nullable Throwable cause) {
        return new WorkerException(message, cause);
    }

    public abstract R getResult();
}

