/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker;

import com.google.caliper.api.AfterRep;
import com.google.caliper.api.BeforeRep;
import com.google.caliper.core.Running;
import com.google.caliper.model.Measurement;
import com.google.caliper.util.Reflection;
import com.google.caliper.worker.AllocationRecorder;
import com.google.caliper.worker.AllocationStats;
import com.google.caliper.worker.instrument.WorkerInstrument;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import javax.inject.Inject;

final class MacrobenchmarkAllocationWorkerInstrument
extends WorkerInstrument {
    private final AllocationRecorder recorder;
    private final ImmutableSet<Method> beforeRepMethods;
    private final ImmutableSet<Method> afterRepMethods;

    @Inject
    MacrobenchmarkAllocationWorkerInstrument(@Running.Benchmark Object benchmark, @Running.BenchmarkMethod Method method, AllocationRecorder recorder) {
        super(benchmark, method);
        this.recorder = recorder;
        this.beforeRepMethods = Reflection.getAnnotatedMethods(benchmark.getClass(), BeforeRep.class);
        this.afterRepMethods = Reflection.getAnnotatedMethods(benchmark.getClass(), AfterRep.class);
    }

    public void bootstrap() throws Exception {
        this.preMeasure(true);
        this.measureAllocations(this.benchmark, this.benchmarkMethod);
        this.postMeasure();
    }

    public void preMeasure(boolean inWarmup) throws Exception {
        for (Method beforeRepMethod : this.beforeRepMethods) {
            beforeRepMethod.invoke(this.benchmark, new Object[0]);
        }
    }

    public void dryRun() throws Exception {
        this.preMeasure(true);
        this.benchmarkMethod.invoke(this.benchmark, new Object[0]);
        this.postMeasure();
    }

    public ImmutableList<Measurement> measure() throws Exception {
        return this.measureAllocations(this.benchmark, this.benchmarkMethod).toMeasurements();
    }

    public void postMeasure() throws Exception {
        for (Method afterRepMethod : this.afterRepMethods) {
            afterRepMethod.invoke(this.benchmark, new Object[0]);
        }
    }

    private AllocationStats measureAllocations(Object benchmark, Method method) throws Exception {
        this.recorder.startRecording();
        method.invoke(benchmark, (Object[])null);
        return this.recorder.stopRecording(1);
    }
}

