/*
 * Copyright (C) 2018 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.caliper.worker.instrument;

import com.google.caliper.bridge.ExperimentSpec;
import javax.inject.Inject;
import javax.inject.Provider;

/** Factory for creating {@link WorkerInstrument}s for running experiments. */
public final class WorkerInstrumentFactory {

  private final Provider<WorkerInstrumentComponent.Builder> builderProvider;

  @Inject
  WorkerInstrumentFactory(Provider<WorkerInstrumentComponent.Builder> builderProvider) {
    this.builderProvider = builderProvider;
  }

  /** Creates the {@link WorkerInstrument} for running the given {@code experiment}. */
  public WorkerInstrument createWorkerInstrument(ExperimentSpec experiment) {
    return builderProvider.get().experiment(experiment).build().instrument();
  }
}
