/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker.handler;

import com.google.caliper.bridge.ShouldContinueMessage;
import com.google.caliper.bridge.StartMeasurementLogMessage;
import com.google.caliper.bridge.StopMeasurementLogMessage;
import com.google.caliper.bridge.TrialRequest;
import com.google.caliper.bridge.VmPropertiesLogMessage;
import com.google.caliper.bridge.WorkerRequest;
import com.google.caliper.model.Measurement;
import com.google.caliper.worker.connection.ClientConnectionService;
import com.google.caliper.worker.handler.RequestHandler;
import com.google.caliper.worker.instrument.WorkerInstrument;
import com.google.caliper.worker.instrument.WorkerInstrumentFactory;
import java.io.IOException;
import java.io.Serializable;
import javax.inject.Inject;

final class TrialHandler
implements RequestHandler {
    private final ClientConnectionService clientConnection;
    private final WorkerInstrumentFactory instrumentFactory;

    @Inject
    TrialHandler(ClientConnectionService clientConnection, WorkerInstrumentFactory instrumentFactory) {
        this.clientConnection = clientConnection;
        this.instrumentFactory = instrumentFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(WorkerRequest request) throws Exception {
        TrialRequest trialRequest = (TrialRequest)request;
        WorkerInstrument workerInstrument = this.instrumentFactory.createWorkerInstrument(trialRequest.experiment());
        this.notifyVmProperties();
        try {
            workerInstrument.setUpBenchmark();
            this.notifyTrialBootstrapPhaseStarting();
            workerInstrument.bootstrap();
            this.notifyTrialMeasurementPhaseStarting();
            boolean keepMeasuring = true;
            boolean isInWarmup = true;
            while (keepMeasuring) {
                workerInstrument.preMeasure(isInWarmup);
                this.notifyTrialMeasurementStarting();
                try {
                    ShouldContinueMessage message = this.notifyTrialMeasurementEnding(workerInstrument.measure());
                    keepMeasuring = message.shouldContinue();
                    isInWarmup = !message.isWarmupComplete();
                }
                finally {
                    workerInstrument.postMeasure();
                }
            }
        }
        finally {
            workerInstrument.tearDownBenchmark();
        }
    }

    private void notifyVmProperties() throws IOException {
        this.clientConnection.send(new Serializable[]{new VmPropertiesLogMessage()});
    }

    private void notifyTrialBootstrapPhaseStarting() throws IOException {
        this.clientConnection.send(new Serializable[]{"Bootstrap phase starting."});
    }

    private void notifyTrialMeasurementPhaseStarting() throws IOException {
        this.clientConnection.send(new Serializable[]{"Measurement phase starting (includes warmup and actual measurement)."});
    }

    private void notifyTrialMeasurementStarting() throws IOException {
        this.clientConnection.send(new Serializable[]{"About to measure.", new StartMeasurementLogMessage()});
    }

    private ShouldContinueMessage notifyTrialMeasurementEnding(Iterable<Measurement> measurements) throws IOException {
        this.clientConnection.send(new Serializable[]{new StopMeasurementLogMessage(measurements)});
        return (ShouldContinueMessage)this.clientConnection.receive();
    }
}

