/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.worker.instrument;

import com.google.caliper.api.AfterRep;
import com.google.caliper.api.BeforeRep;
import com.google.caliper.core.Running;
import com.google.caliper.model.Measurement;
import com.google.caliper.model.Value;
import com.google.caliper.util.Reflection;
import com.google.caliper.util.Util;
import com.google.caliper.worker.instrument.WorkerInstrument;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

final class MacrobenchmarkWorkerInstrument
extends WorkerInstrument {
    private final Stopwatch stopwatch;
    private final ImmutableSet<Method> beforeRepMethods;
    private final ImmutableSet<Method> afterRepMethods;
    private final boolean gcBeforeEach;

    @Inject
    MacrobenchmarkWorkerInstrument(@Running.Benchmark Object benchmark, @Running.BenchmarkMethod Method method, Ticker ticker, @WorkerInstrument.Options Map<String, String> options) {
        super(benchmark, method);
        this.stopwatch = Stopwatch.createUnstarted((Ticker)ticker);
        this.beforeRepMethods = Reflection.getAnnotatedMethods(benchmark.getClass(), BeforeRep.class);
        this.afterRepMethods = Reflection.getAnnotatedMethods(benchmark.getClass(), AfterRep.class);
        this.gcBeforeEach = Boolean.parseBoolean(options.get("gcBeforeEach"));
    }

    @Override
    public void preMeasure(boolean inWarmup) throws Exception {
        for (Method beforeRepMethod : this.beforeRepMethods) {
            beforeRepMethod.invoke(this.benchmark, new Object[0]);
        }
        if (this.gcBeforeEach && !inWarmup) {
            Util.forceGc();
        }
    }

    @Override
    public void dryRun() throws Exception {
        this.preMeasure(true);
        this.benchmarkMethod.invoke(this.benchmark, new Object[0]);
        this.postMeasure();
    }

    @Override
    public Iterable<Measurement> measure() throws Exception {
        this.stopwatch.start();
        this.benchmarkMethod.invoke(this.benchmark, new Object[0]);
        long nanos = this.stopwatch.stop().elapsed(TimeUnit.NANOSECONDS);
        this.stopwatch.reset();
        return ImmutableSet.of((Object)new Measurement.Builder().description("runtime").weight(1.0).value(Value.create((double)nanos, (String)"ns")).build());
    }

    @Override
    public void postMeasure() throws Exception {
        for (Method afterRepMethod : this.afterRepMethods) {
            afterRepMethod.invoke(this.benchmark, new Object[0]);
        }
    }
}

