/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import com.google.cloud.alloydb.ConnectorConfig;
import com.google.cloud.alloydb.ConstantCredentialFactory;
import com.google.cloud.alloydb.CredentialFactory;
import com.google.cloud.alloydb.DefaultCredentialFactory;
import com.google.cloud.alloydb.FileCredentialFactory;
import com.google.cloud.alloydb.ServiceAccountImpersonatingCredentialFactory;
import com.google.cloud.alloydb.SupplierCredentialFactory;

class CredentialFactoryProvider {
    private final CredentialFactory defaultCredentialFactory;

    CredentialFactoryProvider() {
        this.defaultCredentialFactory = new DefaultCredentialFactory();
    }

    CredentialFactoryProvider(CredentialFactory defaultCredentialFactory) {
        this.defaultCredentialFactory = defaultCredentialFactory;
    }

    CredentialFactory getDefaultCredentialFactory() {
        return this.defaultCredentialFactory;
    }

    CredentialFactory getInstanceCredentialFactory(ConnectorConfig config) {
        CredentialFactory instanceCredentialFactory = config.getGoogleCredentialsSupplier() != null ? new SupplierCredentialFactory(config.getGoogleCredentialsSupplier()) : (config.getGoogleCredentials() != null ? new ConstantCredentialFactory(config.getGoogleCredentials()) : (config.getGoogleCredentialsPath() != null ? new FileCredentialFactory(config.getGoogleCredentialsPath()) : this.getDefaultCredentialFactory()));
        if (config.getTargetPrincipal() == null && config.getDelegates() != null && !config.getDelegates().isEmpty()) {
            throw new IllegalArgumentException(String.format("Connection property %s must be when %s is set.", "alloydbTargetPrincipal", "alloydbDelegates"));
        }
        if (config.getTargetPrincipal() != null && !config.getTargetPrincipal().isEmpty()) {
            instanceCredentialFactory = new ServiceAccountImpersonatingCredentialFactory(instanceCredentialFactory, config.getTargetPrincipal(), config.getDelegates());
        }
        return instanceCredentialFactory;
    }
}

