/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import com.google.cloud.alloydb.AccessTokenSupplier;
import com.google.cloud.alloydb.ConnectionConfig;
import com.google.cloud.alloydb.ConnectionInfo;
import com.google.cloud.alloydb.ConnectionInfoCache;
import com.google.cloud.alloydb.ConnectionInfoCacheFactory;
import com.google.cloud.alloydb.ConnectionInfoRepository;
import com.google.cloud.alloydb.ConnectionSocket;
import com.google.cloud.alloydb.ConnectorConfig;
import com.google.common.base.Objects;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyPair;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Connector {
    private static final Logger logger = LoggerFactory.getLogger(Connector.class);
    private static final long MIN_RATE_LIMIT_MS = 30000L;
    private final ListeningScheduledExecutorService executor;
    private final ConnectionInfoRepository connectionInfoRepo;
    private final KeyPair clientConnectorKeyPair;
    private final ConnectionInfoCacheFactory connectionInfoCacheFactory;
    private final ConcurrentHashMap<ConnectionConfig, ConnectionInfoCache> instances;
    private final ConnectorConfig config;
    private final AccessTokenSupplier accessTokenSupplier;
    private final String userAgents;

    Connector(ConnectorConfig config, ListeningScheduledExecutorService executor, ConnectionInfoRepository connectionInfoRepo, KeyPair clientConnectorKeyPair, ConnectionInfoCacheFactory connectionInfoCacheFactory, ConcurrentHashMap<ConnectionConfig, ConnectionInfoCache> instances, AccessTokenSupplier accessTokenSupplier, String userAgents) {
        this.config = config;
        this.executor = executor;
        this.connectionInfoRepo = connectionInfoRepo;
        this.clientConnectorKeyPair = clientConnectorKeyPair;
        this.connectionInfoCacheFactory = connectionInfoCacheFactory;
        this.instances = instances;
        this.accessTokenSupplier = accessTokenSupplier;
        this.userAgents = userAgents;
    }

    public ConnectorConfig getConfig() {
        return this.config;
    }

    public void close() {
        logger.debug("Close all connections and remove them from cache.");
        this.instances.forEach((key, c) -> c.close());
        this.instances.clear();
    }

    Socket connect(ConnectionConfig config) throws IOException {
        ConnectionInfoCache connectionInfoCache = this.getConnection(config);
        ConnectionInfo connectionInfo = connectionInfoCache.getConnectionInfo();
        try {
            ConnectionSocket socket = new ConnectionSocket(connectionInfo, config, this.clientConnectorKeyPair, this.accessTokenSupplier, this.userAgents);
            return socket.connect();
        }
        catch (IOException e) {
            logger.debug(String.format("[%s] Socket connection failed! Trigger a refresh.", config.getInstanceName()));
            connectionInfoCache.forceRefresh();
            throw e;
        }
    }

    ConnectionInfoCache getConnection(ConnectionConfig config) {
        ConnectionInfoCache instance = this.instances.computeIfAbsent(config, k -> this.createConnectionInfo(config));
        instance.refreshIfExpired();
        return instance;
    }

    private ConnectionInfoCache createConnectionInfo(ConnectionConfig config) {
        logger.debug(String.format("[%s] Connection info added to cache.", config.getInstanceName()));
        return this.connectionInfoCacheFactory.create(this.executor, this.connectionInfoRepo, config.getInstanceName(), this.clientConnectorKeyPair, 30000L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Connector)) {
            return false;
        }
        Connector that = (Connector)o;
        return Objects.equal((Object)this.config, (Object)that.config) && Objects.equal((Object)this.executor, (Object)that.executor) && Objects.equal((Object)this.connectionInfoRepo, (Object)that.connectionInfoRepo) && Objects.equal((Object)this.clientConnectorKeyPair, (Object)that.clientConnectorKeyPair) && Objects.equal((Object)this.connectionInfoCacheFactory, (Object)that.connectionInfoCacheFactory) && Objects.equal(this.instances, that.instances) && Objects.equal((Object)this.accessTokenSupplier, (Object)that.accessTokenSupplier) && Objects.equal((Object)this.userAgents, (Object)that.userAgents);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.config, this.executor, this.connectionInfoRepo, this.clientConnectorKeyPair, this.connectionInfoCacheFactory, this.instances, this.accessTokenSupplier, this.userAgents});
    }
}

