/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import com.google.cloud.alloydb.ConnectionConfig;
import com.google.cloud.alloydb.ConnectionInfoCache;
import com.google.cloud.alloydb.Connector;
import com.google.cloud.alloydb.ConnectorConfig;
import com.google.cloud.alloydb.CredentialFactory;
import com.google.cloud.alloydb.CredentialFactoryProvider;
import com.google.cloud.alloydb.DefaultAccessTokenSupplier;
import com.google.cloud.alloydb.DefaultConnectionInfoCacheFactory;
import com.google.cloud.alloydb.DefaultConnectionInfoRepository;
import com.google.cloud.alloydb.DefaultConnectionInfoRepositoryFactory;
import com.google.cloud.alloydb.RsaKeyPairGenerator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;

enum InternalConnectorRegistry implements Closeable
{
    INSTANCE;

    private final ListeningScheduledExecutorService executor;
    private CredentialFactoryProvider credentialFactoryProvider;
    private ConcurrentHashMap<ConnectorConfig, Connector> unnamedConnectors;
    private ConcurrentHashMap<String, Connector> namedConnectors;
    private final Object shutdownGuard = new Object();
    @GuardedBy(value="shutdownGuard")
    private boolean shutdown = false;
    private List<String> userAgents = new ArrayList<String>();
    private static final String USER_AGENT = "alloydb-java-connector/1.1.8";

    private InternalConnectorRegistry() {
        this.executor = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newScheduledThreadPool(8));
        this.unnamedConnectors = new ConcurrentHashMap();
        this.namedConnectors = new ConcurrentHashMap();
        this.credentialFactoryProvider = new CredentialFactoryProvider();
        this.addArtifactId(USER_AGENT);
    }

    @VisibleForTesting
    void setCredentialFactoryProvider(CredentialFactoryProvider credentialFactoryProvider) {
        this.credentialFactoryProvider = credentialFactoryProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket connect(ConnectionConfig config) throws IOException {
        Object object = this.shutdownGuard;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalStateException("ConnectorRegistry was shut down.");
            }
        }
        if (config.getNamedConnector() != null) {
            Connector connector = this.getNamedConnector(config.getNamedConnector());
            return connector.connect(config.withConnectorConfig(connector.getConfig()));
        }
        Preconditions.checkArgument((config.getInstanceName() != null ? 1 : 0) != 0, (Object)"alloydbInstance property not set. Please specify this property in the JDBC URL or the connection Properties");
        return this.getConnector(config).connect(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String name, ConnectorConfig config) {
        Object object = this.shutdownGuard;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalStateException("ConnectorRegistry was shut down.");
            }
        }
        if (this.namedConnectors.containsKey(name)) {
            throw new IllegalArgumentException("Named connection " + name + " exists.");
        }
        this.namedConnectors.put(name, this.createConnector(config));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String name) {
        Object object = this.shutdownGuard;
        synchronized (object) {
            if (this.shutdown) {
                throw new IllegalStateException("ConnectorRegistry was shut down.");
            }
        }
        Connector connector = this.namedConnectors.remove(name);
        if (connector == null) {
            throw new IllegalArgumentException("Named connection " + name + " does not exist.");
        }
        connector.close();
    }

    private void shutdownConnectors() {
        this.unnamedConnectors.forEach((key, c) -> c.close());
        this.unnamedConnectors.clear();
        this.namedConnectors.forEach((key, c) -> c.close());
        this.namedConnectors.clear();
    }

    @Override
    public void close() {
        this.shutdownInstance();
    }

    public void resetInstance() {
        this.shutdownConnectors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownInstance() {
        Object object = this.shutdownGuard;
        synchronized (object) {
            this.shutdown = true;
            this.shutdownConnectors();
            this.executor.shutdown();
        }
    }

    public void addArtifactId(String artifactId) {
        if (!this.userAgents.contains(artifactId)) {
            this.userAgents.add(artifactId);
        }
    }

    @VisibleForTesting
    String getUserAgents() {
        return String.join((CharSequence)" ", this.userAgents);
    }

    private Connector getConnector(ConnectionConfig config) {
        return this.unnamedConnectors.computeIfAbsent(config.getConnectorConfig(), k -> this.createConnector(config.getConnectorConfig()));
    }

    private Connector createConnector(ConnectorConfig config) {
        CredentialFactory instanceCredentialFactory = this.credentialFactoryProvider.getInstanceCredentialFactory(config);
        DefaultConnectionInfoRepositoryFactory connectionInfoRepositoryFactory = new DefaultConnectionInfoRepositoryFactory(this.executor, this.getUserAgents());
        DefaultConnectionInfoRepository connectionInfoRepository = connectionInfoRepositoryFactory.create(instanceCredentialFactory, config);
        DefaultAccessTokenSupplier accessTokenSupplier = new DefaultAccessTokenSupplier(instanceCredentialFactory);
        return new Connector(config, this.executor, connectionInfoRepository, RsaKeyPairGenerator.generateKeyPair(), new DefaultConnectionInfoCacheFactory(), new ConcurrentHashMap<ConnectionConfig, ConnectionInfoCache>(), accessTokenSupplier, this.getUserAgents());
    }

    private Connector getNamedConnector(String name) {
        Connector connector = this.namedConnectors.get(name);
        if (connector == null) {
            throw new IllegalArgumentException("Named connection " + name + " does not exist.");
        }
        return connector;
    }
}

