/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import com.google.cloud.alloydb.ConnectionInfoCache;
import com.google.cloud.alloydb.ConnectionInfoCacheFactory;
import com.google.cloud.alloydb.ConnectionInfoRepository;
import com.google.cloud.alloydb.LazyConnectionInfoCache;
import com.google.cloud.alloydb.RefreshAheadConnectionInfoCache;
import com.google.cloud.alloydb.RefreshStrategy;
import com.google.cloud.alloydb.v1alpha.InstanceName;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import java.security.KeyPair;

class DefaultConnectionInfoCacheFactory
implements ConnectionInfoCacheFactory {
    private final RefreshStrategy refreshStrategy;

    public DefaultConnectionInfoCacheFactory(RefreshStrategy refreshStrategy) {
        this.refreshStrategy = refreshStrategy;
    }

    @Override
    public ConnectionInfoCache create(ListeningScheduledExecutorService executor, ConnectionInfoRepository connectionInfoRepo, InstanceName instanceName, KeyPair clientConnectorKeyPair, long minRefreshDelayMs) {
        if (this.refreshStrategy == RefreshStrategy.LAZY) {
            return new LazyConnectionInfoCache(connectionInfoRepo, instanceName, clientConnectorKeyPair);
        }
        return new RefreshAheadConnectionInfoCache(executor, connectionInfoRepo, instanceName, clientConnectorKeyPair, minRefreshDelayMs);
    }
}

