/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import com.google.cloud.alloydb.AccessTokenSupplier;
import com.google.cloud.alloydb.AuthType;
import com.google.cloud.alloydb.ConnectionConfig;
import com.google.cloud.alloydb.ConnectionInfo;
import com.google.cloud.alloydb.connectors.v1.MetadataExchangeRequest;
import com.google.cloud.alloydb.connectors.v1.MetadataExchangeResponse;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectionSocket {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionSocket.class);
    private static final String TLS_1_3 = "TLSv1.3";
    private static final String X_509 = "X.509";
    private static final String ROOT_CA_CERT = "rootCaCert";
    private static final String CLIENT_CERT = "clientCert";
    private static final int IO_TIMEOUT_MS = 30000;
    private static final int SERVER_SIDE_PROXY_PORT = 5433;
    private final ConnectionInfo connectionInfo;
    private final ConnectionConfig connectionConfig;
    private final KeyPair clientConnectorKeyPair;
    private final AccessTokenSupplier accessTokenSupplier;
    private final String userAgents;

    ConnectionSocket(ConnectionInfo connectionInfo, ConnectionConfig connectionConfig, KeyPair clientConnectorKeyPair, AccessTokenSupplier accessTokenSupplier, String userAgents) {
        this.connectionInfo = connectionInfo;
        this.connectionConfig = connectionConfig;
        this.clientConnectorKeyPair = clientConnectorKeyPair;
        this.accessTokenSupplier = accessTokenSupplier;
        this.userAgents = userAgents;
    }

    Socket connect() throws IOException {
        String address;
        SSLSocket socket = this.buildSocket(this.connectionInfo.getCaCertificate(), this.connectionInfo.getCertificateChain(), this.clientConnectorKeyPair.getPrivate());
        switch (this.connectionConfig.getIpType()) {
            case PUBLIC: {
                address = this.connectionInfo.getPublicIpAddress();
                break;
            }
            case PSC: {
                address = this.connectionInfo.getPscDnsName().replaceFirst("\\.$", "");
                break;
            }
            default: {
                address = this.connectionInfo.getIpAddress();
            }
        }
        if (address == null || address.isEmpty()) {
            throw new RuntimeException(String.format("Instance does not have an address matching type: %s", new Object[]{this.connectionConfig.getIpType()}));
        }
        logger.debug(String.format("[%s] Connecting to instance.", address));
        SSLParameters sslParameters = socket.getSSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        sslParameters.setServerNames(Collections.singletonList(new SNIHostName(address)));
        socket.setSSLParameters(sslParameters);
        socket.setKeepAlive(true);
        socket.setTcpNoDelay(true);
        socket.connect(new InetSocketAddress(address, 5433));
        try {
            socket.startHandshake();
        }
        catch (IOException e) {
            logger.debug("TLS handshake failed!");
            throw e;
        }
        this.metadataExchange(socket);
        logger.debug(String.format("[%s] Connected to instance successfully.", address));
        return socket;
    }

    private SSLSocket buildSocket(X509Certificate caCertificate, List<X509Certificate> certificateChain, PrivateKey privateKey) {
        try {
            KeyManager[] keyManagers = this.initializeKeyManager(certificateChain, privateKey);
            TrustManager[] trustManagers = this.initializeTrustManager(caCertificate);
            SSLContext sslContext = SSLContext.getInstance(TLS_1_3);
            sslContext.init(keyManagers, trustManagers, new SecureRandom());
            return (SSLSocket)sslContext.getSocketFactory().createSocket();
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new RuntimeException("Unable to create an SSL Context for the instance.", ex);
        }
    }

    private TrustManager[] initializeTrustManager(X509Certificate caCertificate) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore trustedKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        trustedKeyStore.load(null, null);
        trustedKeyStore.setCertificateEntry(ROOT_CA_CERT, caCertificate);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(X_509);
        trustManagerFactory.init(trustedKeyStore);
        return trustManagerFactory.getTrustManagers();
    }

    private KeyManager[] initializeKeyManager(List<X509Certificate> certificateChain, PrivateKey privateKey) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyStore clientAuthenticationKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        clientAuthenticationKeyStore.load(null, null);
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        chain.addAll(certificateChain);
        Certificate[] chainArray = chain.toArray(new Certificate[0]);
        KeyStore.PrivateKeyEntry privateKeyEntry = new KeyStore.PrivateKeyEntry(privateKey, chainArray);
        clientAuthenticationKeyStore.setEntry(CLIENT_CERT, privateKeyEntry, new KeyStore.PasswordProtection(new char[0]));
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(clientAuthenticationKeyStore, new char[0]);
        return keyManagerFactory.getKeyManagers();
    }

    private void metadataExchange(SSLSocket socket) throws IOException {
        logger.debug("Metadata exchange initiated.");
        MetadataExchangeRequest.AuthType authType = MetadataExchangeRequest.AuthType.DB_NATIVE;
        if (this.connectionConfig.getAuthType().equals((Object)AuthType.IAM)) {
            authType = MetadataExchangeRequest.AuthType.AUTO_IAM;
        }
        String tokenValue = this.accessTokenSupplier.getTokenValue();
        MetadataExchangeRequest request = MetadataExchangeRequest.newBuilder().setAuthType(authType).setOauth2Token(tokenValue).setUserAgent(this.userAgents).build();
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        out.writeInt(request.getSerializedSize());
        out.write(request.toByteArray());
        out.flush();
        socket.setSoTimeout(30000);
        DataInputStream in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        int respSize = in.readInt();
        byte[] respData = new byte[respSize];
        in.readFully(respData);
        socket.setSoTimeout(0);
        MetadataExchangeResponse response = MetadataExchangeResponse.parseFrom((byte[])respData);
        if (response == null || !response.getResponseCode().equals((Object)MetadataExchangeResponse.ResponseCode.OK)) {
            throw new RuntimeException(response != null ? response.getError() : "Metadata exchange response is null.");
        }
        logger.debug("Metadata exchange completed successfully.");
    }
}

