/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.alloydb;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ImpersonatedCredentials;
import com.google.cloud.alloydb.CredentialFactory;
import java.util.Arrays;
import java.util.List;

class ServiceAccountImpersonatingCredentialFactory
implements CredentialFactory {
    private final CredentialFactory source;
    private final List<String> delegates;
    private final String targetPrincipal;

    ServiceAccountImpersonatingCredentialFactory(CredentialFactory source, String targetPrincipal, List<String> delegates) {
        if (targetPrincipal == null || targetPrincipal.isEmpty()) {
            throw new IllegalArgumentException("targetPrincipal must not be empty");
        }
        this.source = source;
        this.delegates = delegates;
        this.targetPrincipal = targetPrincipal;
    }

    @Override
    public GoogleCredentials getCredentials() {
        GoogleCredentials credentials = this.source.getCredentials();
        credentials = ImpersonatedCredentials.newBuilder().setSourceCredentials(credentials).setTargetPrincipal(this.targetPrincipal).setDelegates(this.delegates).setScopes(Arrays.asList("https://www.googleapis.com/auth/cloud-platform")).build();
        return credentials;
    }
}

