/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.artifactregistry.auth;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.artifactregistry.auth.CredentialProvider;
import com.google.cloud.artifactregistry.auth.GcloudCredentials;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCredentialProvider
implements CredentialProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GcloudCredentials.class.getName());
    private static String[] SCOPES = new String[]{"https://www.googleapis.com/auth/cloud-platform", "https://www.googleapis.com/auth/cloud-platform.read-only"};

    @Override
    public Credentials getCredential() throws IOException {
        LOGGER.info("ArtifactRegistry Maven Wagon: Retrieving credentials...");
        LOGGER.info("Trying Application Default Credentials...");
        try {
            GoogleCredentials credentials = GoogleCredentials.getApplicationDefault().createScoped(SCOPES);
            LOGGER.info("Using Application Default Credentials.");
            return credentials;
        }
        catch (IOException ex) {
            LOGGER.info("Failed to retrieve Application Default Credentials: " + ex.getMessage());
            LOGGER.info("Trying to retrieve credentials from gcloud...");
            try {
                GcloudCredentials credentials = GcloudCredentials.tryCreateGcloudCredentials();
                LOGGER.info("Using credentials retrieved from gcloud.");
                return credentials;
            }
            catch (IOException ex2) {
                LOGGER.info("Failed to retrieve credentials from gcloud: " + ex2.getMessage());
                LOGGER.info("ArtifactRegistry Maven Wagon: No credentials could be found.");
                throw new IOException("Failed to find credentials Check info logs for more details.");
            }
        }
    }
}

