/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.artifactregistry.auth;

import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.GenericData;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;

public class GcloudCredentials
extends GoogleCredentials {
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static final String KEY_ACCESS_TOKEN = "access_token";
    private static final String KEY_TOKEN_EXPIRY = "token_expiry";

    private GcloudCredentials(AccessToken initialToken) {
        super(initialToken);
    }

    public AccessToken refreshAccessToken() throws IOException {
        return GcloudCredentials.getGcloudAccessToken();
    }

    public static GcloudCredentials tryCreateGcloudCredentials() throws IOException {
        try {
            return new GcloudCredentials(GcloudCredentials.getGcloudAccessToken());
        }
        catch (IOException e) {
            throw new IOException("Failed to get access token from gcloud: " + e.getMessage());
        }
    }

    private static String gCloudCommand() {
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        return isWindows ? "gcloud.cmd" : "gcloud";
    }

    private static AccessToken getGcloudAccessToken() throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        String gcloud = GcloudCredentials.gCloudCommand();
        processBuilder.command(gcloud, "config", "config-helper", "--format=json(credential)");
        Process process = processBuilder.start();
        try {
            int exitCode = process.waitFor();
            String stdOut = GcloudCredentials.readStreamToString(process.getInputStream());
            if (exitCode != 0) {
                String stdErr = GcloudCredentials.readStreamToString(process.getErrorStream());
                throw new IOException(String.format("gcloud exited with status: %d\nOutput:\n%s\nError Output:\n%s\n", exitCode, stdOut, stdErr));
            }
            GenericData result = (GenericData)JSON_FACTORY.fromString(stdOut, GenericData.class);
            Map credential = (Map)result.get((Object)"credential");
            if (credential == null) {
                throw new IOException("No credential returned from gcloud");
            }
            if (!credential.containsKey(KEY_ACCESS_TOKEN) || !credential.containsKey(KEY_TOKEN_EXPIRY)) {
                throw new IOException("Malformed response from gcloud");
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date expiry = df.parse((String)credential.get(KEY_TOKEN_EXPIRY));
            return new AccessToken((String)credential.get(KEY_ACCESS_TOKEN), expiry);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ParseException e) {
            throw new IOException("Failed to parse timestamp from gcloud output", e);
        }
    }

    private static String readStreamToString(InputStream input) throws IOException {
        int nRead;
        InputStreamReader reader = new InputStreamReader(input);
        StringBuilder output = new StringBuilder();
        char[] buf = new char[2048];
        while ((nRead = reader.read(buf)) != -1) {
            output.append(buf, 0, nRead);
        }
        return output.toString();
    }
}

