/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.artifactregistry.auth;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.artifactregistry.auth.CredentialProvider;
import com.google.cloud.artifactregistry.auth.GcloudCredentials;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultCredentialProvider
implements CredentialProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GcloudCredentials.class.getName());
    private static String[] SCOPES = new String[]{"https://www.googleapis.com/auth/cloud-platform", "https://www.googleapis.com/auth/cloud-platform.read-only"};
    private GoogleCredentials cachedCredentials;
    private static final DefaultCredentialProvider defaultInstance = new DefaultCredentialProvider();
    public static long LAST_REFRESH_TIME_MS = 0L;
    public static final long REFESH_INTERVAL_MS = Duration.ofSeconds(10L).toMillis();

    public static DefaultCredentialProvider getInstance() {
        return defaultInstance;
    }

    private DefaultCredentialProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Credentials getCredential() throws IOException {
        DefaultCredentialProvider defaultCredentialProvider = this;
        synchronized (defaultCredentialProvider) {
            if (this.cachedCredentials == null) {
                LOGGER.info("Initializing Credentials...");
                this.cachedCredentials = this.makeGoogleCredentials();
            }
            this.refreshIfNeeded();
            return this.cachedCredentials;
        }
    }

    public void refreshIfNeeded() throws IOException {
        long now = Instant.now().toEpochMilli();
        if (this.cachedCredentials != null && now > LAST_REFRESH_TIME_MS + REFESH_INTERVAL_MS) {
            LOGGER.info("Refreshing Credentials...");
            this.cachedCredentials.refreshIfExpired();
            LAST_REFRESH_TIME_MS = now;
        }
    }

    public GoogleCredentials makeGoogleCredentials() throws IOException {
        LOGGER.debug("ArtifactRegistry: Retrieving credentials...");
        LOGGER.debug("Trying Application Default Credentials...");
        try {
            GoogleCredentials credentials = GoogleCredentials.getApplicationDefault().createScoped(SCOPES);
            LOGGER.info("Using Application Default Credentials.");
            return credentials;
        }
        catch (IOException ex) {
            LOGGER.info("Application Default Credentials unavailable.");
            LOGGER.debug("Failed to retrieve Application Default Credentials: " + ex.getMessage());
            LOGGER.debug("Trying gcloud credentials...");
            try {
                GcloudCredentials credentials = GcloudCredentials.tryCreateGcloudCredentials();
                LOGGER.info("Using credentials retrieved from gcloud.");
                return credentials;
            }
            catch (IOException ex2) {
                LOGGER.info("Failed to retrieve credentials from gcloud: " + ex2.getMessage());
                LOGGER.info("ArtifactRegistry: No credentials could be found.");
                throw new IOException("Failed to find credentials Check debug logs for more details.");
            }
        }
    }
}

