/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.artifactregistry.wagon;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.auth.Credentials;
import com.google.auth.http.HttpTransportFactory;
import com.google.cloud.artifactregistry.auth.CredentialProvider;
import com.google.cloud.artifactregistry.auth.DefaultCredentialProvider;
import com.google.cloud.artifactregistry.wagon.ArtifactRegistryRequestInitializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.maven.wagon.AbstractWagon;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;

public final class ArtifactRegistryWagon
extends AbstractWagon {
    private GoogleRepository googleRepository;
    private HttpRequestFactory requestFactory;
    private boolean hasCredentials;
    private HttpTransportFactory httpTransportFactory = NetHttpTransport::new;
    private CredentialProvider credentialProvider = new DefaultCredentialProvider();
    private Credentials credentials;

    private InputStream getInputStream(Resource resource) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            GenericUrl url = this.googleRepository.constructURL(resource.getName());
            HttpRequest request = this.requestFactory.buildGetRequest(url);
            HttpResponse response = request.execute();
            return response.getContent();
        }
        catch (HttpResponseException e) {
            this.rethrowAuthorizationException(e);
            this.rethrowNotFoundException(e);
            throw new TransferFailedException("Received an error from the remote server.", (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Failed to send request to remote server.", (Throwable)e);
        }
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        HttpTransport httpTransport = this.httpTransportFactory.create();
        try {
            this.credentials = this.credentialProvider.getCredential();
            ArtifactRegistryRequestInitializer requestInitializer = new ArtifactRegistryRequestInitializer(this.credentials, this.getReadTimeout());
            this.requestFactory = httpTransport.createRequestFactory((HttpRequestInitializer)requestInitializer);
            this.hasCredentials = true;
        }
        catch (IOException e) {
            this.requestFactory = httpTransport.createRequestFactory();
        }
        this.googleRepository = new GoogleRepository(this.repository);
    }

    protected void closeConnection() throws ConnectionException {
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.getIfNewer(resourceName, destination, 0L);
    }

    public boolean resourceExists(String resource) throws TransferFailedException, AuthorizationException {
        try {
            GenericUrl url = this.googleRepository.constructURL(resource);
            HttpRequest request = this.requestFactory.buildHeadRequest(url);
            return request.execute().isSuccessStatusCode();
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            this.rethrowAuthorizationException(e);
            throw new TransferFailedException("Received an error from the remote server.", (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Failed to send request to remote server.", (Throwable)e);
        }
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(resourceName);
        this.fireGetInitiated(resource, destination);
        try {
            this.fireGetStarted(resource, destination);
            InputStream input = this.getInputStream(resource);
            this.getTransfer(resource, destination, input);
            this.fireGetCompleted(resource, destination);
        }
        catch (Exception e) {
            this.fireTransferError(resource, e, 5);
            throw e;
        }
        return true;
    }

    public void setHttpTransportFactory(HttpTransportFactory httpTransportFactory) {
        this.httpTransportFactory = httpTransportFactory;
    }

    public void setCredentialProvider(CredentialProvider provider) {
        this.credentialProvider = provider;
    }

    private void handlePutRequest(final File source, final Resource resource, GenericUrl url) throws AuthorizationException, ResourceDoesNotExistException, TransferFailedException {
        try {
            HttpRequest request = this.requestFactory.buildPutRequest(url, new HttpContent(){

                public long getLength() throws IOException {
                    return source.length();
                }

                public String getType() {
                    return null;
                }

                public boolean retrySupported() {
                    return true;
                }

                public void writeTo(OutputStream out) throws IOException {
                    try {
                        ArtifactRegistryWagon.this.putTransfer(resource, source, out, false);
                    }
                    catch (ResourceDoesNotExistException | TransferFailedException | AuthorizationException e) {
                        throw new FileTransferException(e);
                    }
                }
            });
            request.execute();
        }
        catch (HttpResponseException e) {
            this.rethrowAuthorizationException(e);
            this.rethrowNotFoundException(e);
            throw new TransferFailedException("Received an error from the remote server.", (Throwable)e);
        }
        catch (FileTransferException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TransferFailedException) {
                throw (TransferFailedException)cause;
            }
            if (cause instanceof AuthorizationException) {
                throw (AuthorizationException)cause;
            }
            if (cause instanceof ResourceDoesNotExistException) {
                throw (ResourceDoesNotExistException)cause;
            }
            throw new TransferFailedException("Error uploading file.", cause);
        }
        catch (IOException e) {
            throw new TransferFailedException("Failed to send request to remote server.", (Throwable)e);
        }
    }

    public void put(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = new Resource(destination);
        this.firePutInitiated(resource, source);
        resource.setContentLength(source.length());
        resource.setLastModified(source.lastModified());
        GenericUrl url = this.googleRepository.constructURL(resource.getName());
        this.firePutStarted(resource, source);
        this.handlePutRequest(source, resource, url);
        this.firePutCompleted(resource, source);
    }

    private void rethrowAuthorizationException(HttpResponseException e) throws AuthorizationException {
        if (e.getStatusCode() == 403 || e.getStatusCode() == 401) {
            String errorMessage = "Permission denied on remote repository (or it may not exist). ";
            if (!this.hasCredentials) {
                errorMessage = errorMessage + "The request had no credentials because none were available from the environment. Ensure that either 1) You are logged into gcloud or 2) Application default credentials are setup (see https://developers.google.com/accounts/docs/application-default-credentials for more information).";
            }
            throw new AuthorizationException(errorMessage, (Throwable)e);
        }
    }

    private void rethrowNotFoundException(HttpResponseException e) throws ResourceDoesNotExistException {
        if (e.getStatusCode() == 404) {
            throw new ResourceDoesNotExistException("The remote resource does not exist.", (Throwable)e);
        }
    }

    private static class GoogleRepository {
        private final Repository repository;

        GoogleRepository(Repository repository) {
            this.repository = repository;
        }

        GenericUrl constructURL(String artifactPath) {
            GenericUrl url = new GenericUrl();
            url.setScheme("https");
            url.setHost(this.repository.getHost());
            url.appendRawPath(this.repository.getBasedir());
            url.appendRawPath("/");
            url.appendRawPath(artifactPath);
            return url;
        }
    }

    private static class FileTransferException
    extends IOException {
        FileTransferException(Throwable cause) {
            super(cause);
        }
    }
}

