/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.artifactregistry.wagon;

import com.google.cloud.artifactregistry.auth.CommandExecutor;
import com.google.cloud.artifactregistry.auth.CommandExecutorResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;

public class ProcessBuilderCommandExecutor
implements CommandExecutor {
    public CommandExecutorResult executeCommand(String command, String ... args) throws IOException {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(command);
        argList.addAll(Arrays.asList(args));
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(argList);
        Process process = processBuilder.start();
        try {
            int exitCode = process.waitFor();
            String stdOut = ProcessBuilderCommandExecutor.readStreamToString(process.getInputStream());
            String stdErr = ProcessBuilderCommandExecutor.readStreamToString(process.getErrorStream());
            return new CommandExecutorResult(exitCode, stdOut, stdErr);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
    }

    private static String readStreamToString(InputStream input) throws IOException {
        int nRead;
        InputStreamReader reader = new InputStreamReader(input);
        StringBuilder output = new StringBuilder();
        char[] buf = new char[2048];
        while ((nRead = reader.read(buf)) != -1) {
            output.append(buf, 0, nRead);
        }
        return output.toString();
    }
}

