/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Unstable
public enum BigQueryFileFormat {
    CSV(".csv", "CSV"),
    NEWLINE_DELIMITED_JSON(".json", "NEWLINE_DELIMITED_JSON"),
    AVRO(".avro", "AVRO");

    private static final Map<String, BigQueryFileFormat> NAMES_MAP;
    private static final String ACCEPTED_FORMATS;
    private final String extension;
    private final String formatIdentifier;

    private BigQueryFileFormat(String extension, String formatIdentifier) {
        this.extension = extension;
        this.formatIdentifier = formatIdentifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getFormatIdentifier() {
        return this.formatIdentifier;
    }

    public static BigQueryFileFormat fromName(String name) {
        BigQueryFileFormat entry = NAMES_MAP.get(name);
        if (entry == null) {
            throw new IllegalArgumentException("Unable to find BigQueryFileFormat for '" + name + "'. Accepted formats are: [ " + ACCEPTED_FORMATS + " ]");
        }
        return entry;
    }

    static {
        NAMES_MAP = new HashMap<String, BigQueryFileFormat>();
        ArrayList<String> formats = new ArrayList<String>();
        for (BigQueryFileFormat format : BigQueryFileFormat.values()) {
            NAMES_MAP.put(format.name(), format);
            formats.add(format.name());
        }
        ACCEPTED_FORMATS = Joiner.on((char)',').join(formats);
    }
}

