/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.ReadOptions;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import com.google.cloud.hadoop.io.bigquery.BigQueryConfiguration;
import com.google.cloud.hadoop.io.bigquery.BigQueryFactory;
import com.google.cloud.hadoop.io.bigquery.BigQueryHelper;
import com.google.cloud.hadoop.io.bigquery.DirectBigQueryRecordReader;
import com.google.cloud.hadoop.io.bigquery.HadoopConfigurationProperty;
import com.google.cloud.hadoop.util.ConfigurationUtil;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

@InterfaceStability.Evolving
public class DirectBigQueryInputFormat
extends InputFormat<NullWritable, GenericRecord> {
    private static final HadoopConfigurationProperty<Integer> DIRECT_PARALLELISM = new HadoopConfigurationProperty<Integer>("mapreduce.job.maps", 10, new String[0]);

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        BigQueryHelper bigQueryHelper;
        Configuration configuration = context.getConfiguration();
        BigQueryStorageClient client = this.getClient(configuration);
        try {
            bigQueryHelper = this.getBigQueryHelper(configuration);
        }
        catch (GeneralSecurityException gse) {
            throw new IOException("Failed to create BigQuery client", gse);
        }
        double skewLimit = (Double)BigQueryConfiguration.SKEW_LIMIT.get(configuration, (arg_0, arg_1) -> ((Configuration)configuration).getDouble(arg_0, arg_1));
        Preconditions.checkArgument((skewLimit >= 1.0 ? 1 : 0) != 0, (String)"%s is less than 1; not all records would be read. Exiting", (Object)BigQueryConfiguration.SKEW_LIMIT.getKey());
        Table table = DirectBigQueryInputFormat.getTable(configuration, bigQueryHelper);
        Storage.ReadSession session = DirectBigQueryInputFormat.startSession(configuration, table, client);
        long numRows = table.getNumRows().longValue();
        long limit = Math.round(skewLimit * (double)numRows / (double)session.getStreamsCount());
        return session.getStreamsList().stream().map(stream -> new DirectBigQueryInputSplit(stream.getName(), session.getAvroSchema().getSchema(), limit)).collect(Collectors.toList());
    }

    private static Table getTable(Configuration configuration, BigQueryHelper bigQueryHelper) throws IOException {
        Map mandatoryConfig = ConfigurationUtil.getMandatoryConfig((Configuration)configuration, BigQueryConfiguration.MANDATORY_CONFIG_PROPERTIES_INPUT);
        String inputProjectId = (String)mandatoryConfig.get(BigQueryConfiguration.INPUT_PROJECT_ID.getKey());
        String datasetId = (String)mandatoryConfig.get(BigQueryConfiguration.INPUT_DATASET_ID.getKey());
        String tableName = (String)mandatoryConfig.get(BigQueryConfiguration.INPUT_TABLE_ID.getKey());
        TableReference tableReference = new TableReference().setDatasetId(datasetId).setProjectId(inputProjectId).setTableId(tableName);
        return bigQueryHelper.getTable(tableReference);
    }

    private static Storage.ReadSession startSession(Configuration configuration, Table table, BigQueryStorageClient client) {
        String jobProjectId = (String)BigQueryConfiguration.PROJECT_ID.get(configuration, (arg_0, arg_1) -> ((Configuration)configuration).get(arg_0, arg_1));
        String filter = (String)BigQueryConfiguration.SQL_FILTER.get(configuration, (arg_0, arg_1) -> ((Configuration)configuration).get(arg_0, arg_1));
        Collection selectedFields = BigQueryConfiguration.SELECTED_FIELDS.getStringCollection(configuration);
        ReadOptions.TableReadOptions.Builder readOptions = ReadOptions.TableReadOptions.newBuilder().setRowRestriction(filter);
        if (!selectedFields.isEmpty()) {
            readOptions.addAllSelectedFields((Iterable)selectedFields);
        }
        Storage.CreateReadSessionRequest request = Storage.CreateReadSessionRequest.newBuilder().setTableReference(TableReferenceProto.TableReference.newBuilder().setProjectId(table.getTableReference().getProjectId()).setDatasetId(table.getTableReference().getDatasetId()).setTableId(table.getTableReference().getTableId())).setRequestedStreams(((Integer)DIRECT_PARALLELISM.get(configuration, (arg_0, arg_1) -> ((Configuration)configuration).getInt(arg_0, arg_1))).intValue()).setParent("projects/" + jobProjectId).setReadOptions(readOptions).setFormat(Storage.DataFormat.AVRO).build();
        return client.createReadSession(request);
    }

    public RecordReader<NullWritable, GenericRecord> createRecordReader(InputSplit inputSplit, TaskAttemptContext context) {
        return new DirectBigQueryRecordReader();
    }

    protected BigQueryStorageClient getClient(Configuration config) throws IOException {
        return BigQueryStorageClient.create();
    }

    protected BigQueryHelper getBigQueryHelper(Configuration config) throws GeneralSecurityException, IOException {
        BigQueryFactory factory = new BigQueryFactory();
        return factory.getBigQueryHelper(config);
    }

    public static class DirectBigQueryInputSplit
    extends InputSplit
    implements Writable {
        private String name;
        private String schema;
        private long limit;

        public DirectBigQueryInputSplit() {
        }

        public DirectBigQueryInputSplit(String name, String schema, long limit) {
            this.name = name;
            this.schema = schema;
            this.limit = limit;
        }

        public long getLength() {
            return -1L;
        }

        public String[] getLocations() {
            return new String[0];
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.name);
            out.writeUTF(this.schema);
            out.writeLong(this.limit);
        }

        public void readFields(DataInput in) throws IOException {
            this.name = in.readUTF();
            this.schema = in.readUTF();
            this.limit = in.readLong();
        }

        public String getName() {
            return this.name;
        }

        public String getSchema() {
            return this.schema;
        }

        public long getLimit() {
            return this.limit;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.schema, this.limit);
        }

        private Object[] values() {
            return new Object[]{this.name, this.schema, this.limit};
        }

        public boolean equals(Object o) {
            if (!(o instanceof DirectBigQueryInputSplit)) {
                return false;
            }
            return Arrays.equals(this.values(), ((DirectBigQueryInputSplit)((Object)o)).values());
        }

        public String toString() {
            return String.format("(name='%s', schema='%s', limit='%s')", this.name, this.schema, this.limit);
        }
    }
}

