/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.io.bigquery;

import com.google.cloud.bigquery.storage.v1beta1.BigQueryStorageClient;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.hadoop.io.bigquery.DirectBigQueryInputFormat;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class DirectBigQueryRecordReader
extends RecordReader<NullWritable, GenericRecord> {
    private Schema schema;
    private Storage.Stream stream;
    private Schema.Parser parser = new Schema.Parser();
    private GenericRecord current;
    private boolean finalized;
    private long limit;
    private long idx;
    private BigQueryStorageClient client;
    private Iterator<Storage.ReadRowsResponse> responseIterator;
    private Iterator<GenericRecord> recordIterator;

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        DirectBigQueryInputFormat.DirectBigQueryInputSplit split = (DirectBigQueryInputFormat.DirectBigQueryInputSplit)genericSplit;
        this.schema = this.parser.parse((String)Preconditions.checkNotNull((Object)split.getSchema(), (Object)"schema"));
        this.stream = Storage.Stream.newBuilder().setName((String)Preconditions.checkNotNull((Object)split.getName(), (Object)"name")).build();
        Storage.ReadRowsRequest request = Storage.ReadRowsRequest.newBuilder().setReadPosition(Storage.StreamPosition.newBuilder().setStream(this.stream).build()).build();
        this.client = this.getClient(context.getConfiguration());
        this.responseIterator = this.client.readRowsCallable().call((Object)request).iterator();
        this.recordIterator = Collections.emptyIterator();
        this.limit = split.getLimit();
        this.idx = 0L;
        this.finalized = false;
    }

    public boolean nextKeyValue() {
        if (++this.idx >= this.limit && !this.finalized) {
            this.client.finalizeStream(this.stream);
            this.finalized = true;
        }
        if (this.responseIterator.hasNext() && !this.recordIterator.hasNext()) {
            this.recordIterator = new AvroRecordIterator(this.schema, this.responseIterator.next().getAvroRows().getSerializedBinaryRows());
        }
        if (this.recordIterator.hasNext()) {
            this.current = this.recordIterator.next();
            return true;
        }
        this.current = null;
        return false;
    }

    public NullWritable getCurrentKey() {
        return NullWritable.get();
    }

    public GenericRecord getCurrentValue() {
        return this.current;
    }

    public float getProgress() {
        return -1.0f;
    }

    public void close() {
    }

    protected BigQueryStorageClient getClient(Configuration conf) throws IOException {
        return BigQueryStorageClient.create();
    }

    private static class AvroRecordIterator
    implements Iterator<GenericRecord> {
        private final BinaryDecoder in;
        private final GenericDatumReader<GenericRecord> reader;

        AvroRecordIterator(Schema schema, ByteString bytes) {
            this.reader = new GenericDatumReader(schema);
            this.in = new DecoderFactory().binaryDecoder(bytes.toByteArray(), null);
        }

        @Override
        public boolean hasNext() {
            try {
                return !this.in.isEnd();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to check for more records", e);
            }
        }

        @Override
        public GenericRecord next() {
            try {
                return (GenericRecord)this.reader.read(null, (Decoder)this.in);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read more records", e);
            }
        }
    }
}

