/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystem;
import com.google.cloud.hadoop.util.LogUtil;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class GoogleHadoopFS
extends AbstractFileSystem {
    public static final LogUtil log = new LogUtil(GoogleHadoopFS.class);
    private GoogleHadoopFileSystem ghfs;

    public GoogleHadoopFS(URI uri, Configuration conf) throws URISyntaxException, IOException {
        this(new GoogleHadoopFileSystem(), uri, conf);
    }

    public GoogleHadoopFS(GoogleHadoopFileSystem ghfs, URI uri, Configuration conf) throws URISyntaxException, IOException {
        super(uri, ghfs.getScheme(), true, 0);
        Preconditions.checkArgument((ghfs != null ? 1 : 0) != 0, (Object)"ghfs must not be null");
        this.ghfs = ghfs;
        ghfs.initialize(uri, conf);
    }

    public FSDataOutputStream createInternal(Path file, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws IOException {
        log.debug("createInternal: flag: %s, absolutePermission: %s, bufferSize: %s, replication: %s,blockSize: %s, progress: %s, checksumOpt: %s, createParent: %s", new Object[]{flag, absolutePermission, bufferSize, replication, blockSize, progress, checksumOpt, createParent});
        if (!createParent) {
            log.debug("Ignoring createParent=false. Creating parents anyways.", new Object[0]);
        }
        boolean overwriteFile = true;
        return this.ghfs.create(file, absolutePermission, overwriteFile, bufferSize, replication, blockSize, progress);
    }

    public int getUriDefaultPort() {
        log.debug("getUriDefaultPort", new Object[0]);
        return this.ghfs.getDefaultPort();
    }

    public URI getUri() {
        return this.ghfs.getUri();
    }

    public boolean isValidName(String src) {
        StringTokenizer tokens = new StringTokenizer(src, "/");
        while (tokens.hasMoreTokens()) {
            String element = tokens.nextToken();
            if (!element.equals("..") && !element.equals(".")) continue;
            return false;
        }
        return true;
    }

    public void checkPath(Path path) {
        super.checkPath(path);
        this.ghfs.checkPath(path);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        log.debug("getServerDefaults", new Object[0]);
        return this.ghfs.getServerDefaults();
    }

    public void mkdir(Path dir, FsPermission permission, boolean createParent) throws IOException {
        log.debug("mkdir: dir: %s, permission: %s, createParent %s", new Object[]{dir, permission, createParent});
        if (!createParent) {
            log.debug("Ignoring createParent=false. Creating parents anyways.", new Object[0]);
        }
        this.ghfs.mkdirs(dir, permission);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        log.debug("delete", new Object[0]);
        return this.ghfs.delete(f, recursive);
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        log.debug("open", new Object[0]);
        return this.ghfs.open(f, bufferSize);
    }

    public boolean setReplication(Path f, short replication) throws IOException {
        log.debug("setReplication", new Object[0]);
        return this.ghfs.setReplication(f, replication);
    }

    public void renameInternal(Path src, Path dst) throws IOException {
        log.debug("renameInternal", new Object[0]);
        this.ghfs.rename(src, dst);
    }

    public void setPermission(Path f, FsPermission permission) throws IOException {
        log.debug("setPermission", new Object[0]);
        this.ghfs.setPermission(f, permission);
    }

    public void setOwner(Path f, String username, String groupname) throws IOException {
        log.debug("setOwner", new Object[0]);
        this.ghfs.setOwner(f, username, groupname);
    }

    public void setTimes(Path f, long mtime, long atime) throws IOException {
        log.debug("setTimes", new Object[0]);
        this.ghfs.setTimes(f, mtime, atime);
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        log.debug("getFileChecksum", new Object[0]);
        return this.ghfs.getFileChecksum(f);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        log.debug("getFileStatus", new Object[0]);
        return this.ghfs.getFileStatus(f);
    }

    public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws IOException {
        log.debug("getFileBlockLocations", new Object[0]);
        return this.ghfs.getFileBlockLocations(f, start, len);
    }

    public FsStatus getFsStatus() throws IOException {
        log.debug("getFsStatus", new Object[0]);
        return this.ghfs.getStatus();
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        log.debug("listStatus", new Object[0]);
        return this.ghfs.listStatus(f);
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        log.debug("setVerifyChecksum", new Object[0]);
        this.ghfs.setVerifyChecksum(verifyChecksum);
    }
}

