/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.gcsio.SeekableReadableByteChannel;
import com.google.cloud.hadoop.util.LogUtil;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileSystem;

class GoogleHadoopFSInputStream
extends FSInputStream {
    private static LogUtil log = new LogUtil(GoogleHadoopFSInputStream.class);
    private GoogleHadoopFileSystemBase ghfs;
    private SeekableReadableByteChannel channel;
    private ByteBuffer buffer;
    private URI gcsPath;
    private long totalBytesRead;
    private final FileSystem.Statistics statistics;
    private long initTime;

    GoogleHadoopFSInputStream(GoogleHadoopFileSystemBase ghfs, URI gcsPath, int bufferSize, FileSystem.Statistics statistics) throws IOException {
        log.debug("GoogleHadoopFSInputStream(%s, %d)", new Object[]{gcsPath, bufferSize});
        this.ghfs = ghfs;
        this.gcsPath = gcsPath;
        this.statistics = statistics;
        this.initTime = System.nanoTime();
        this.totalBytesRead = 0L;
        this.channel = ghfs.getGcsFs().open(gcsPath);
        this.buffer = ByteBuffer.allocate(bufferSize);
        this.buffer.limit(0);
        this.buffer.rewind();
    }

    public synchronized int read() throws IOException {
        long startTime = System.nanoTime();
        if (!this.buffer.hasRemaining()) {
            this.buffer.clear();
            int numBytesRead = this.channel.read(this.buffer);
            if (numBytesRead <= 0) {
                this.buffer.limit(0);
                this.buffer.rewind();
                return -1;
            }
            this.buffer.flip();
        }
        byte b = this.buffer.get();
        ++this.totalBytesRead;
        this.statistics.incrementBytesRead(1L);
        long duration = System.nanoTime() - startTime;
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ1);
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ1_TIME, duration);
        return b & 0xFF;
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        long startTime = System.nanoTime();
        Preconditions.checkNotNull((Object)buf, (Object)"buf must not be null");
        if (offset < 0 || length < 0 || length > buf.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        int numRead = 0;
        while (numRead < length) {
            int needToRead = length - numRead;
            if (this.buffer.remaining() >= needToRead) {
                this.buffer.get(buf, offset + numRead, needToRead);
                numRead += needToRead;
                continue;
            }
            if (this.buffer.hasRemaining()) {
                int singleRead = this.buffer.remaining();
                this.buffer.get(buf, offset + numRead, singleRead);
                numRead += singleRead;
                continue;
            }
            long channelTime = System.nanoTime();
            this.buffer.clear();
            int numNewBytes = this.channel.read(this.buffer);
            long channelDuration = System.nanoTime() - channelTime;
            this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ_FROM_CHANNEL);
            this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ_FROM_CHANNEL_TIME, channelDuration);
            if (numNewBytes <= 0) {
                this.buffer.limit(0);
                this.buffer.rewind();
                if (numRead != 0) break;
                numRead = -1;
                break;
            }
            this.buffer.flip();
        }
        if (numRead > 0) {
            this.statistics.incrementBytesRead((long)numRead);
            this.totalBytesRead += (long)numRead;
        }
        long duration = System.nanoTime() - startTime;
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ);
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ_TIME, duration);
        return numRead;
    }

    public int read(long position, byte[] buf, int offset, int length) throws IOException {
        long startTime = System.nanoTime();
        int result = super.read(position, buf, offset, length);
        long duration = System.nanoTime() - startTime;
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ_POS);
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ_POS_TIME, duration);
        return result;
    }

    public synchronized long getPos() throws IOException {
        long pos = this.channel.position() - (long)this.buffer.remaining();
        log.debug("getPos: %d", new Object[]{pos});
        return pos;
    }

    public synchronized void seek(long pos) throws IOException {
        long startTime = System.nanoTime();
        log.debug("seek: %d", new Object[]{pos});
        long curPos = this.getPos();
        if (curPos == pos) {
            log.debug("Skipping no-op seek.", new Object[0]);
        } else if (pos < curPos && curPos - pos <= (long)this.buffer.position()) {
            long skipBack = curPos - pos;
            int newBufferPosition = this.buffer.position() - (int)skipBack;
            log.debug("Skipping backward %d bytes in-place from buffer pos %s to new pos %s", new Object[]{skipBack, this.buffer.position(), newBufferPosition});
            this.buffer.position(newBufferPosition);
        } else if (curPos < pos && pos < this.channel.position()) {
            long skipBytes = pos - curPos;
            Preconditions.checkState((skipBytes < (long)this.buffer.remaining() ? 1 : 0) != 0, (String)"skipBytes (%s) must be less than buffer.remaining() (%s)", (Object[])new Object[]{skipBytes, this.buffer.remaining()});
            int newBufferPosition = this.buffer.position() + (int)skipBytes;
            log.debug("Skipping %d bytes in-place from buffer pos %d to new pos %d", new Object[]{skipBytes, this.buffer.position(), newBufferPosition});
            this.buffer.position(newBufferPosition);
        } else {
            log.debug("New position '%d' out of range of inplace buffer, with curPos (%d), buffer.position() (%d) and buffer.remaining() (%d).", new Object[]{pos, curPos, this.buffer.position(), this.buffer.remaining()});
            try {
                this.channel.position(pos);
            }
            catch (IllegalArgumentException e) {
                throw new IOException(e);
            }
            this.buffer.limit(0);
            this.buffer.rewind();
        }
        long duration = System.nanoTime() - startTime;
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.SEEK);
        this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.SEEK_TIME, duration);
    }

    public synchronized boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        if (this.channel != null) {
            long startTime = System.nanoTime();
            try {
                log.debug("close: file: %s, totalBytesRead: %d", new Object[]{this.gcsPath, this.totalBytesRead});
                this.channel.close();
                long duration = System.nanoTime() - startTime;
                this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ_CLOSE);
                this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.READ_CLOSE_TIME, duration);
                long streamDuration = System.nanoTime() - this.initTime;
                this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.INPUT_STREAM);
                this.ghfs.increment(GoogleHadoopFileSystemBase.Counter.INPUT_STREAM_TIME, streamDuration);
            }
            finally {
                this.channel = null;
            }
        }
    }

    public boolean markSupported() {
        return false;
    }
}

