/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.fs.gcs;

import com.google.cloud.hadoop.fs.gcs.GoogleHadoopFileSystemBase;
import com.google.cloud.hadoop.gcsio.GoogleCloudStorageFileSystem;
import com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.fs.Path;

public class GoogleHadoopFileSystem
extends GoogleHadoopFileSystemBase {
    private String rootBucket;

    public GoogleHadoopFileSystem() {
    }

    public GoogleHadoopFileSystem(GoogleCloudStorageFileSystem gcsfs) {
        super(gcsfs);
    }

    @Override
    @VisibleForTesting
    public void configureBuckets(String systemBucketName, boolean createConfiguredBuckets) throws IOException {
        super.configureBuckets(systemBucketName, createConfiguredBuckets);
        this.rootBucket = this.initUri.getAuthority();
        if (this.rootBucket != null) {
            GoogleCloudStorageFileSystem.getPath(this.rootBucket);
        } else if (this.systemBucket != null) {
            log.warn("GHFS.configureBuckets: Warning. No GCS bucket provided. Falling back on deprecated fs.gs.system.bucket.", new Object[0]);
            this.rootBucket = this.systemBucket;
        } else {
            String msg = String.format("No bucket specified in GCS URI: %s", this.initUri);
            throw new IllegalArgumentException(msg);
        }
        log.debug("GHFS.configureBuckets: GoogleHadoopFileSystem root in bucket: ", new Object[]{this.rootBucket});
    }

    @Override
    protected void checkPath(Path path) {
        super.checkPath(path);
        URI uri = path.toUri();
        String bucket = uri.getAuthority();
        if (bucket == null || bucket.equals(this.rootBucket)) {
            return;
        }
        String msg = String.format("Wrong bucket: %s, in path: %s, expected bucket: %s", bucket, path, this.rootBucket);
        throw new IllegalArgumentException(msg);
    }

    @VisibleForTesting
    String getRootBucketName() {
        return this.rootBucket;
    }

    @Override
    protected String getHomeDirectorySubpath() {
        String string = String.valueOf(System.getProperty("user.name"));
        return string.length() != 0 ? "user/".concat(string) : new String("user/");
    }

    @Override
    public Path getHadoopPath(URI gcsPath) {
        log.debug("GHFS.getHadoopPath: %s", new Object[]{gcsPath});
        if (gcsPath.equals(this.getGcsPath(this.getFileSystemRoot()))) {
            return this.getFileSystemRoot();
        }
        StorageResourceId resourceId = GoogleCloudStorageFileSystem.validatePathAndGetId(gcsPath, true);
        if (resourceId.isRoot()) {
            throw new IllegalArgumentException(String.format("Missing authority in gcsPath '%s'", gcsPath.toString()));
        }
        if (!resourceId.getBucketName().equals(this.rootBucket)) {
            throw new IllegalArgumentException(String.format("Authority of URI '%s' doesn't match root bucket '%s'", resourceId.getBucketName(), this.rootBucket));
        }
        String string = String.valueOf(String.valueOf(this.getScheme()));
        String string2 = String.valueOf(String.valueOf(this.rootBucket));
        String string3 = String.valueOf(String.valueOf(resourceId.getObjectName()));
        Path hadoopPath = new Path(new StringBuilder(4 + string.length() + string2.length() + string3.length()).append(string).append("://").append(string2).append("/").append(string3).toString());
        log.debug("GHFS.getHadoopPath: %s -> %s", new Object[]{gcsPath, hadoopPath});
        return hadoopPath;
    }

    @Override
    public URI getGcsPath(Path hadoopPath) {
        log.debug("GHFS.getGcsPath: %s", new Object[]{hadoopPath});
        Path resolvedPath = this.makeQualified(hadoopPath);
        String objectName = resolvedPath.toUri().getPath();
        if (objectName != null && resolvedPath.isAbsolute()) {
            objectName = objectName.substring(1);
        }
        URI gcsPath = GoogleCloudStorageFileSystem.getPath(this.rootBucket, objectName, true);
        log.debug("GHFS.getGcsPath: %s -> %s", new Object[]{hadoopPath, gcsPath});
        return gcsPath;
    }

    @Override
    public String getScheme() {
        return "gs";
    }

    @Override
    public Path getFileSystemRoot() {
        String string = String.valueOf(String.valueOf(this.getScheme()));
        String string2 = String.valueOf(String.valueOf(this.rootBucket));
        return new Path(new StringBuilder(4 + string.length() + string2.length()).append(string).append("://").append(string2).append("/").toString());
    }

    @Override
    public Path getDefaultWorkingDirectory() {
        return this.getFileSystemRoot();
    }
}

